<?php
// Database connection
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "car_registration";

$conn = new mysqli($servername, $username, $password, $dbname);

// Check the connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Check the type of request and respond accordingly
if ($_SERVER["REQUEST_METHOD"] == "GET" && isset($_GET['type'])) {
    $type = $_GET['type'];

    if ($type === 'make') {
        // Fetch car makes from the `make` column in the make_brand table
        $sqlMakes = "SELECT make FROM make_brand";
        $resultMakes = $conn->query($sqlMakes);

        if ($resultMakes->num_rows > 0) {
            // Start creating the options for the <select> element for makes
            while ($row = $resultMakes->fetch_assoc()) {
                echo "<option value='" . htmlspecialchars($row['make']) . "'>" . htmlspecialchars($row['make']) . "</option>";
            }
        } else {
            echo "<option value=''>No makes available</option>";
        }
    } elseif ($type === 'color') {
        // Fetch car colors from the `color` column in the car_colors table
        $sqlColors = "SELECT color FROM color"; // Assuming the table name is car_colors and the column is color
        $resultColors = $conn->query($sqlColors);

        if ($resultColors->num_rows > 0) {
            while ($row = $resultColors->fetch_assoc()) {
                echo "<option value='" . htmlspecialchars($row['color']) . "'>" . htmlspecialchars($row['color']) . "</option>";
            }
        } else {
            echo "<option value=''>No colors available</option>";
        }
    }
    // Close the connection
    $conn->close();
    exit(); // Terminate script after serving the options
}


// Handle POST request for car registration
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Sanitize and validate input
    $make = $conn->real_escape_string($_POST['make']);
    $model = $conn->real_escape_string($_POST['model']);
    $year = $conn->real_escape_string($_POST['year']);
    $color = $conn->real_escape_string($_POST['color']);
    $fuel = $conn->real_escape_string($_POST['fuel']);
    $price = $conn->real_escape_string($_POST['price']);
    $photo = $conn->real_escape_string($_POST['photo']);
    $registration_number = $conn->real_escape_string($_POST['registration_number']);
    $vin = $conn->real_escape_string($_POST['vin']);

    // Handle car image upload
    $target_dir = "../photo/";
    $target_file = $target_dir . basename($_FILES["photo"]["name"]);
    $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

    // Check if the image file is valid
    $check = getimagesize($_FILES["photo"]["tmp_name"]);
    if ($check !== false) {
        // Move the uploaded file to the uploads directory
        if (move_uploaded_file($_FILES["photo"]["tmp_name"], $target_file)) {
            $car_image = $target_file;

            // Check if the VIN already exists
            $stmt = $conn->prepare("SELECT vin FROM cars WHERE vin = ?");
            $stmt->bind_param("s", $vin);
            $stmt->execute();
            $stmt->store_result();

            if ($stmt->num_rows > 0) {
                // VIN already exists
                echo "duplicate_vin";
            } else {
                // Insert the car data into the database
                $stmt = $conn->prepare("INSERT INTO cars (make, model, year, color, fuel, price, registration_number, vin, photo) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
                $stmt->bind_param("sssssssss", $make, $model, $year, $color, $fuel, $price, $registration_number, $vin, $car_image);

                if ($stmt->execute()) {
                    echo "success";
                    header("Location: ../html/main.php");
                    exit();
                } else {
                    echo "Error: Could not save car data.";
                }
            }
            $stmt->close();
        } else {
            echo "Error: Failed to upload image.";
        }
    } else {
        echo "Error: File is not a valid image.";
    }

    $conn->close();
}
?>
