document.addEventListener("DOMContentLoaded", function () {
    // Fetch the car makes
    fetch("../php/register_car.php?type=make", {
        method: "GET"
    })
        .then(response => response.text())
        .then(options => {
            document.getElementById("make").innerHTML += options; // Populate the select with car makes
        })
        .catch(error => {
            console.error("Error fetching car makes:", error);
        });

    // Fetch the car colors
    fetch("../php/register_car.php?type=color", {
        method: "GET"
    })
        .then(response => response.text())
        .then(options => {
            document.getElementById("color").innerHTML += options; // Populate the select with car colors
        })
        .catch(error => {
            console.error("Error fetching car colors:", error);
        });
});


document.getElementById("carForm").addEventListener("submit", function(event) {
    event.preventDefault();

    var formData = new FormData(this);

    // Send the form data using an AJAX request
    fetch("../php/register_car.php", {
        method: "POST",
        body: formData
    })
        .then(response => response.text())
        .then(result => {
            if (result === "success") {
                alert("Your car data has been successfully registered!");
                document.getElementById("carForm").reset(); // Reset the form
            } else {
                alert("Error: Unable to register car data.");
            }
        })
        .catch(error => {
            console.error("Error:", error);
        });
});
// Get the modal
var modal = document.getElementById("leasingModal");

// Get the button that opens the modal
var btn = document.getElementById("leasingBtn");

// Get the <span> element that closes the modal
var span = document.getElementsByClassName("close")[0];

// When the user clicks the button, open the modal
btn.onclick = function() {
    modal.style.display = "block";
}

// When the user clicks on <span> (x), close the modal
span.onclick = function() {
    modal.style.display = "none";
}

// When the user clicks anywhere outside of the modal, close it
window.onclick = function(event) {
    if (event.target == modal) {
        modal.style.display = "none";
    }
}