<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Car Catalog</title>
    <link rel="stylesheet" href="../css/styles2.css">
    <style>
        /* Modal styling */
        .modal {
            display: none; /* Hidden by default */
            position: fixed;
            z-index: 1; /* Sit on top */
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0,0,0,0.5); /* Black with opacity */
        }

        .modal-content {
            background-color: #fefefe;
            margin: 15% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 80%;
            max-width: 600px;
            position: relative;
        }

        .close {
            position: absolute;
            top: 10px;
            right: 15px;
            color: #aaa;
            font-size: 28px;
            font-weight: bold;
        }

        .close:hover,
        .close:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }
    </style>
</head>
<body>
<header>
    <h1>Car Catalog</h1>
    <nav>
        <a href="login.html">Login</a>
        <a href="../php/index.php">Auto dati</a>
        <a href="about.html">About</a>
        <a href="#" id="leasingBtn">Lizings</a> <!-- Button to trigger the modal -->
    </nav>
    <div class="filter">
        <input type="text" placeholder="Search cars..." aria-label="Search cars">
    </div>
</header>

<div class="container">
    <?php
    // Database connection
    $servername = "localhost";
    $username = "root";
    $password = "";
    $dbname = "car_registration";

    $conn = new mysqli($servername, $username, $password, $dbname);
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    // Fetch car data
    $sql = "SELECT make, model, year, color, fuel, price, photo FROM cars";
    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            echo "<div class='car-item'>";
            echo "<img src='" . htmlspecialchars($row['photo']) . "' alt='Car Photo'>";
            echo "<div class='car-info'>";
            echo "<h3>" . htmlspecialchars($row['make']) . " " . htmlspecialchars($row['model']) . "</h3>";
            echo "<p>Year: " . htmlspecialchars($row['year']) . "</p>";
            echo "<p>Color: " . htmlspecialchars($row['color']) . "</p>";
            echo "<p>Fuel: " . htmlspecialchars($row['fuel']) . "</p>";
            echo "<p>Price: " . htmlspecialchars($row['price']) . "</p>";
            echo "</div>";
            echo "</div>";
        }
    } else {
        echo "<p>No cars registered yet.</p>";
    }

    $conn->close();
    ?>
</div>

<!-- Leasing Modal -->
<div id="leasingModal" class="modal">
    <div class="modal-content">
        <span class="close">&times;</span>
        <h2>Leasing Information</h2>
        <p><a href="https://elizings.lv/lv/car-credit-leasing" target="_blank">Click here for leasing information</a></p>
    </div>
</div>


<script>
    // Get the modal
    var modal = document.getElementById("leasingModal");

    // Get the button that opens the modal
    var btn = document.getElementById("leasingBtn");

    // Get the <span> element that closes the modal
    var span = document.getElementsByClassName("close")[0];

    // When the user clicks the button, open the modal
    btn.onclick = function() {
        modal.style.display = "block";
    }

    // When the user clicks on <span> (x), close the modal
    span.onclick = function() {
        modal.style.display = "none";
    }

    // When the user clicks anywhere outside of the modal, close it
    window.onclick = function(event) {
        if (event.target == modal) {
            modal.style.display = "none";
        }
    }
</script>
</body>
</html>
