<?php
// Iekļaujam datu bāzes savienojumu
include('../includes/db.php');

// Pārbauda, vai forma ir nosūtīta
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Iegūst ievadītos datus
    $username = $_POST['username'];
    $email = $_POST['email'];
    $password = $_POST['password'];
    $password_confirm = $_POST['password_confirm'];

    // Pārbauda, vai paroles sakrīt
    if ($password !== $password_confirm) {
        $error_message = "Paroles nesakrīt!";
    } else {
        // Pārbaudām, vai lietotājvārds vai e-pasts jau eksistē datu bāzē
        include('sql/get_user.php');
        $stmt =$mysqli ->prepare($query);
        $stmt->bind_param("ss", $username, $email);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
             // Lietotājs jau eksistē, izvadām kļūdas paziņojumu
            $error_message = "Šāds lietotājs jau ir reģistrēts!";
        } else {
            // Ja lietotājs neeksistē, sagatavojam paroles hash un saglabājam lietotāju datu bāzē
            $password_hash = password_hash($password, PASSWORD_DEFAULT);
             include('sql/save_user.php');
            $stmt =$mysqli ->prepare($insert_query);
            $stmt->bind_param("sss", $username, $email, $password_hash);
            $stmt->execute();

            // Pārbauda vai reģistrācija bija veiksmīga
            if ($stmt->affected_rows > 0) {
                header("Location: login.php");
                exit();
            } else {
                $error_message = "Reģistrācijas kļūda!";
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reģistrēties</title>
    <link rel="stylesheet" href="../assets/style.css">
</head>
<body>
    <h1>Reģistrēties</h1>
    
    <?php
    // Ja ir kļūda, parādām ziņojumu
    if (isset($error_message)) {
        echo "<p style='color: red;'>$error_message</p>";
    }
    ?>
    
     <!-- Reģistrācijas forma -->
    <form action="register.php" method="POST">
        <label for="username">Lietotājvārds:</label>
        <input type="text" name="username" required>
        <br>
        <label for="email">E-pasts:</label>
        <input type="email" name="email" required>
        <br>
        <label for="password">Parole:</label>
        <input type="password" name="password" required>
        <br>
        <label for="password_confirm">Apstiprināt paroli:</label>
        <input type="password" name="password_confirm" required>
        <br>
        <button type="submit">Reģistrēties</button>
    </form>

    <!-- Norāde uz pieteikšanās lapu -->
    <p>Jau ir konts? <a href="login.php">Pieslēdzieties šeit</a>.</p>
</body>
</html>
