<?php
// Iekļaujam datu bāzes savienojumu
include('../includes/db.php');

// Sākam sesiju, lai pārbaudītu lietotāja autentifikāciju
session_start();

// Pārbaudām, vai lietotājs ir pieteicies
if (!isset($_SESSION['user_id'])) {
      // Ja lietotājs nav pieteicies, pāradresē uz pieteikšanās lapu
    header('Location: login.php');
    exit();
}

// Iekļaujam SQL vaicājumu citātu veidu iegūšanai
include('sql/quotes_types.php');

// Izpildām vaicājumu, lai iegūtu unikālus citātu veidus
$result = $mysqli->query($query);

$types = []; // Masīvs, kurā glabāsim citātu veidus
if ($result && $result->num_rows > 0) {
    // Pievienojam katru atrasto veidu masīvam
    while ($row = $result->fetch_assoc()) {
        $types[] = $row['type'];
    }
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <!-- Pievienojam CSS stilus -->
        <link rel="stylesheet" href="../assets/style.css">
    <title>Citātu Veidi</title>
</head>
<body>
 <!-- Galvenais virsraksts -->
    <h1>Izvēlies citātu veidu!</h1>
    <?php if (count($types) > 0): ?>
     <!-- Katrs citātu veids tiek attēlots kā poga -->
        <?php foreach ($types as $type): ?>
            <button onclick="window.location.href='quotes.php?type=<?php echo urlencode($type); ?>'">
                <?php echo htmlspecialchars($type); ?>
            </button>
        <?php endforeach; ?>
    <?php else: ?>
     <!-- Ziņojums, ja nav pieejami citātu veidi -->
        <p>Nav pieejami citātu veidi.</p>
    <?php endif; ?>
        <!-- Atpakaļ navigācijas poga -->
    <button class="back" onclick="window.location.href='main.php'">Atpakaļ uz galveno lapu</button>
</body>
</html>
