<?php
// Iekļaujam datu bāzes savienojumu, lai piekļūtu nepieciešamajiem datiem
include('../includes/db.php');

// Sākam sesiju, lai pārbaudītu, vai lietotājs ir pieteicies
session_start();

// Pārbaudām, vai lietotājs ir autentificējies
if (!isset($_SESSION['user_id'])) {
    // Ja lietotājs nav pieteicies, novirzām uz pieteikšanās lapu
    header('Location: login.php');
    exit();
}

// Pārbaudām, vai GET pieprasījumā ir norādīts citātu veids
$type = isset($_GET['type']) ? $_GET['type'] : null;

if ($type) {
    // Iekļaujam SQL vaicājumu, kas izvēlas nejaušu citātu pēc veida
    include('sql/quotes.php');
    
    // Sagatavojam un izpildām vaicājumu ar parametru
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param("s", $type);
    $stmt->execute();
    $result = $stmt->get_result();

 // Pārbaudām, vai ir atrasts kāds citāts
    if ($result && $result->num_rows > 0) {
        $quoteData = $result->fetch_assoc();
        $quote = $quoteData['quote'];
        $author = $quoteData['author'];
    } else {
         // Ja nav pieejams neviena citāta, parādām noklusējuma ziņu
        $quote = "Citāts šajā kategorijā nav pieejams.";
        $author = "Nezināms autors";
    }
} else {
      // Ja nav norādīts citātu veids, novirzām lietotāju atpakaļ uz citātu veidu lapu
    header('Location: quotes_types.php'); 
    exit();
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <link rel="stylesheet" href="../assets/style.css">
    <title>Citāts</title>
</head>
<body>
    <!-- Citāta veida virsraksts -->
    <h1><?php echo htmlspecialchars($type); ?> Citāts</h1>
    
        <!-- Citāta izkārtojums -->
    <blockquote>
        <p><?php echo htmlspecialchars($quote); ?></p>
        <footer>— <?php echo htmlspecialchars($author); ?></footer>
    </blockquote>
    
    <!-- Poga atpakaļ uz citātu veidu izvēli -->
    <button class="back" onclick="window.location.href='quotes_types.php'">Atpakaļ uz veidu izvēli</button>
</body>
</html>
