<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Main Page</title>
    <link rel="stylesheet" href="../assets/style.css">
</head>
<body>
<?php
// Iekļaujam datu bāzes savienojumu
include('../includes/db.php');  // Adjust the path if necessary

// Pārbaudām, vai GET parametrs `meditation_id` ir pieejams
if (isset($_GET['meditation_id'])) {
    $meditation_id = $_GET['meditation_id'];

    // Vaicājums meditācijas informācijas iegūšanai pēc ID
    include('sql/meditation_info.php');
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param("i", $meditation_id); // Saistām meditācijas ID ar vaicājumu
    $stmt->execute();
    $result = $stmt->get_result();

   // Pārbaudām, vai atrasta meditācija
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
          // Izvadām meditācijas nosaukumu un aprakstu
        echo "<h1>" . htmlspecialchars($row['name']) . "</h1>"; 
        echo "<p>" . nl2br(htmlspecialchars($row['description'])) . "</p>"; 
        // Izvadām YouTube video, ja pieejama saite
?>
 <iframe width="420" height="315"
src="<?php echo $row['link']?>"
frameborder="0" 
allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" 
referrerpolicy="strict-origin-when-cross-origin" 
allowfullscreen>
</iframe>

<br>
<?php
    } else {
        // Ziņojums, ja meditācija nav atrasta
        echo "Meditation not found.";
    }

      // Aizveram vaicājumu
    $stmt->close();
} else {
    echo "No meditation ID provided.";
}

// Aizveram datu bāzes savienojumu
$mysqli->close();
?>
<!-- Navigācijas poga atpakaļ uz meditāciju veidu lapu -->
    <button class="back" onclick="window.location.href='meditation_types.php'">Atpakaļ uz veidu lapu</button>
</body>
</html>
