<?php
// Iekļaujam datu bāzes savienojumu
include('../includes/db.php'); // Adjust the path if necessary

// Sāk sesiju, lai pārvaldītu lietotāja pieteikšanos
session_start();

// Pārbaudām, vai lietotājs ir pieteicies
if (!isset($_SESSION['user_id'])) {
     // Ja lietotājs nav pieteicies, novirzām uz pieteikšanās lapu
    header('Location: login.php');
    exit();
}

// Iegūstam pieteikušā lietotāja ID no sesijas mainīgā
$user_id = $_SESSION['user_id'];

// Sagatavojam SQL vaicājumu lietotāja informācijas iegūšanai
include('sql/main.php');
$stmt =$mysqli->prepare($query); 
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Main Page</title>
    
       <!-- Pievienojam CSS stila failu -->
    <link rel="stylesheet" href="../assets/style.css">
</head>
<body>
 <!-- Lietotāja sveiciens ar dinamisku lietotājvārdu -->
    <h1>Sveiki, <?php echo htmlspecialchars($user['username']); ?>!</h1>
   
       <!-- Navigācijas pogas uz dažādām sadaļām -->
    <button onclick="window.location.href='meditation_types.php'">Meditācijas veidi</button>
    <button onclick="window.location.href='quotes.php'">Motivējoši citāti</button>
    <button onclick="window.location.href='chat.php'">Saruna ar tērzēšanas robotu</button>

</body>
</html>
