<?php
// Iekļaujam datu bāzes savienojumu
include('../includes/db.php');

// Sesija sākšana
session_start();

// Pārbaudām, vai lietotājs jau ir pieteicies
if (isset($_SESSION['user_id'])) {
     // Ja lietotājs ir pieteicies, pārsūtām uz galveno lapu
    header("Location: main.php");
    exit();
}

// Pārbaudām, vai forma tika nosūtīta ar POST metodi
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
   // Pārbaudām, vai lietotājs ir ievadījis gan e-pastu, gan paroli
    if (isset($_POST['email']) && isset($_POST['password'])) {
        $email = $_POST['email'];
        $password = $_POST['password'];

           // SQL vaicājums lietotāja meklēšanai pēc e-pasta
       include('sql/index.php');
        $stmt = $mysqli->prepare($query);
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $result = $stmt->get_result();

         // Pārbaudām, vai datubāzē tika atrasts lietotājs ar šo e-pasta adresi
        if ($result->num_rows > 0) {
            $user = $result->fetch_assoc();

             // Pārbaudām, vai lietotāja ievadītā parole atbilst datubāzē esošajai
            if (password_verify($password, $user['password'])) {
                  // Iestatām sesijas mainīgo ar lietotāja ID un pārsūtām uz galveno lapu
                $_SESSION['user_id'] = $user['user_id'];
                header("Location: main.php");
                exit();
            } else {
                // Ja parole ir nepareiza
                echo "Nepareiza parole.";
            }
        } else {
             // Ja lietotājs ar ievadīto e-pastu nav atrasts
            echo "Lietotājs ar šo e-pasta adresi neeksistē.";
        }
    } else {
          // Ja nav ievadīts e-pasts vai parole
        echo "Lūdzu ievadiet e-pastu un paroli.";
    }
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pieteikšanās</title>
    
    <!-- Stilu lapa (CSS), kas nosaka lapas izskatu -->
    <link rel="stylesheet" href="../assets/style.css">
</head>
<body>
    <h1>Pieteikšanās</h1>
    <!-- Pieteikšanās forma -->
    <form action="index.php" method="POST">
     <!-- Ievades lauks e-pasta adresei -->
        <label for="email">E-pasts:</label>
        <input type="email" name="email" required>
        <br>
        
     <!-- Ievades lauks paroles ievadīšanai -->
        <label for="password">Parole:</label>
        <input type="password" name="password" required>
        <br>
        
           <!-- Pieteikšanās pogas elements -->
        <button type="submit">Pieteikties</button>
    </form>

     <!-- Saites elements uz reģistrācijas lapu -->
    <p>Ja vēl neesat reģistrējušies, <a href="register.php">reģistrējieties šeit</a>.</p>
</body>
</html>
