<?php
// Sāk sesiju, lai saglabātu lietotāja sesijas datus 
session_start();

// Iekļauj datu bāzes savienojumu
include('../includes/db.php'); // Adjust path if needed

// Pārbauda, vai lietotājs ir pieteicies
if (!isset($_SESSION['user_id'])) {
     // Ja lietotājs nav pieteicies, pāradresē uz pieteikšanās lapu
    header('Location: login.php');
    exit();
}

// Pārbauda, vai saņemts POST pieprasījums un lietotāja ziņojums nav tukšs
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['user_message'])) {
        // Apgriež liekās atstarpes lietotāja ievadītajā ziņojumā
    $user_message = trim($_POST['user_message']);

    if (!empty($user_message)) {
            // Ievieto lietotāja ziņojumu datu bāzē
        $stmt = $mysqli->prepare("INSERT INTO chatbot_responses (user_message) VALUES (?)");
        $stmt->bind_param("s", $user_message);
        $stmt->execute();

         // Iegūst tērzēšanas robota atbildi, pamatojoties uz lietotāja ziņojumu
        $bot_response = getBotResponse($user_message);

        // Atjaunina datu bāzē robota atbildi attiecīgajam lietotāja ziņojumam
        $stmt = $mysqli->prepare("UPDATE chatbot_responses SET bot_response = ? WHERE user_message = ?");
        $stmt->bind_param("ss", $bot_response, $user_message);
        $stmt->execute();
    }
}

// Funkcija, kas simulē tērzēšanas robota atbildi
function getBotResponse($message) {
    if (strpos(strtolower($message), 'sveiki') !== false) {
        return 'Sveiki! Kā varu palīdzēt?';
    } elseif (strpos(strtolower($message), 'palīdzība') !== false) {
        return 'Es varu palīdzēt jums ar meditācijām vai motivāciju.';
    } else {
        return 'Piedodiet, es nesapratu jūsu jautājumu.';
    }
}

// Vaicājums, lai iegūtu visus ziņojumus no datu bāzes hronoloģiskā secībā
$stmt = $mysqli->query("SELECT * FROM chatbot_responses ORDER BY created_at ASC");
// Iegūst ziņojumu masīvu no vaicājuma rezultāta
$messages = $stmt->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chat Bot</title>
    <link rel="stylesheet" href="../assets/style.css"> <!-- CSS faila saite vizuālam stilam -->
</head>
<body>
    <h1>Saruna ar tērzēšanas robotu</h1>
<!-- Tērzēšanas logs, kur tiek attēloti lietotāja un robota ziņojumi -->
    <div id="chat-window">
        <div id="messages">
         <!-- Iterācija caur datu bāzes ziņojumiem un to attēlošana -->
            <?php foreach ($messages as $message) : ?>
                <div>
                    <strong>Jūs:</strong> <?php echo htmlspecialchars($message['user_message']); ?>
                </div>
                <div>
                    <strong>Bots:</strong> <?php echo htmlspecialchars($message['bot_response']); ?>
                </div>
            <?php endforeach; ?>
        </div>

 <!-- Forma ziņojuma nosūtīšanai -->
        <form method="POST">
            <input type="text" id="user-input" name="user_message" placeholder="Ieraksti ziņojumu..." />
            <button type="submit" id="send-btn">Sūtīt</button>
        </form>
    </div>

<!-- Saite uz JavaScript funkcijām -->
    <script src="../assets/app.js"></script>
       <!-- Atpakaļ uz galveno lapu poga -->
        <button class="back" onclick="window.location.href='main.php'">Atpakaļ uz galveno lapu</button>
</body>
</html>
