<?php
// Include the database connection
include('../includes/db.php');

// Start the session
session_start();

// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Fetch all unique quote types from the database
$query = "SELECT DISTINCT type FROM quotes";
$result = $mysqli->query($query);

$types = [];
if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $types[] = $row['type'];
    }
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <link rel="stylesheet" href="../assets/style.css">
    <title>Citātu Veidi</title>
</head>
<body>
    <h1>Izvēlies citātu veidu!</h1>
    <?php if (count($types) > 0): ?>
        <?php foreach ($types as $type): ?>
            <button onclick="window.location.href='quotes.php?type=<?php echo urlencode($type); ?>'">
                <?php echo htmlspecialchars($type); ?>
            </button>
        <?php endforeach; ?>
    <?php else: ?>
        <p>Nav pieejami citātu veidi.</p>
    <?php endif; ?>
    <button class="back" onclick="window.location.href='main.php'">Atpakaļ uz galveno lapu</button>
</body>
</html>
