<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Main Page</title>
    <link rel="stylesheet" href="../assets/style.css">
</head>
<body>
<?php
// Include database connection
include('../includes/db.php');  // Adjust the path if necessary

// Check if meditation_id is passed through URL
if (isset($_GET['meditation_id'])) {
    $meditation_id = $_GET['meditation_id'];

    // Query to get details of the meditation based on its ID
    $query = "SELECT * FROM meditations WHERE meditation_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param("i", $meditation_id); // Binding the meditation ID to the query
    $stmt->execute();
    $result = $stmt->get_result();

    // Check if the meditation is found
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        echo "<h1>" . htmlspecialchars($row['name']) . "</h1>"; // Display the name
        echo "<p>" . nl2br(htmlspecialchars($row['description'])) . "</p>"; // Display the description
?>
 <iframe width="420" height="315"
src="<?php echo $row['link']?>"
frameborder="0" 
allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" 
referrerpolicy="strict-origin-when-cross-origin" 
allowfullscreen>
</iframe>

<br>
<?php
    } else {
        echo "Meditation not found.";
    }

    // Close the statement and connection
    $stmt->close();
} else {
    echo "No meditation ID provided.";
}

$mysqli->close();
?>
    <button class="back" onclick="window.location.href='meditation_types.php'">Atpakaļ uz veidu lapu</button>
</body>
</html>
