<?php
// Include the database connection
include('../includes/db.php'); // Adjust the path if necessary

// Start the session
session_start();

// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Fetch the logged-in user's information
$user_id = $_SESSION['user_id'];

// Prepare the query to get user information
$query = "SELECT username FROM users WHERE user_id = ?";
$stmt =$mysqli->prepare($query); // Using$mysqli for the database connection
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Main Page</title>
    <link rel="stylesheet" href="../assets/style.css">
</head>
<body>
    <h1>Sveiki, <?php echo htmlspecialchars($user['username']); ?>!</h1>

    <!-- Buttons -->
   
    <button onclick="window.location.href='meditation_types.php'">Meditācijas veidi</button>
    <button onclick="window.location.href='quotes.php'">Motivējoši citāti</button>
    <button onclick="window.location.href='chat.php'">Saruna ar tērzēšanas robotu</button>

</body>
</html>
