<?php
// Iekļaujam datu bāzes savienojumu
include('../includes/db.php');

// Sesija sākšana
session_start();

// Pārbaudām, vai lietotājs jau ir pieteicies
if (isset($_SESSION['user_id'])) {
    header("Location: main.php");
    exit();
}

// Pārbauda, vai forma ir nosūtīta
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Pārbauda, vai ievadītās vērtības ir pieejamas
    if (isset($_POST['email']) && isset($_POST['password'])) {
        $email = $_POST['email'];
        $password = $_POST['password'];

        // SQL vaicājums lietotāja meklēšanai pēc e-pasta
        $query = "SELECT * FROM users WHERE email = ?";
        $stmt = $mysqli->prepare($query);
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $result = $stmt->get_result();

        // Ja lietotājs atrasts, pārbaudām paroli
        if ($result->num_rows > 0) {
            $user = $result->fetch_assoc();

            // Pārbauda paroli
            if (password_verify($password, $user['password'])) {
                // Iestata sesiju un pārsūta uz galveno lapu
                $_SESSION['user_id'] = $user['user_id'];
                header("Location: main.php");
                exit();
            } else {
                echo "Nepareiza parole.";
            }
        } else {
            echo "Lietotājs ar šo e-pasta adresi neeksistē.";
        }
    } else {
        echo "Lūdzu ievadiet e-pastu un paroli.";
    }
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pieteikšanās</title>
    <link rel="stylesheet" href="../assets/style.css">
</head>
<body>
    <h1>Pieteikšanās</h1>
    <!-- Login form -->
    <form action="index.php" method="POST">
        <label for="email">E-pasts:</label>
        <input type="email" name="email" required>
        <br>
        <label for="password">Parole:</label>
        <input type="password" name="password" required>
        <br>
        <button type="submit">Pieteikties</button>
    </form>

    <!-- Registration link -->
    <p>Ja vēl neesat reģistrējušies, <a href="register.php">reģistrējieties šeit</a>.</p>
</body>
</html>
