<?php
// Start session
session_start();

// Include the database connection
include('../includes/db.php'); // Adjust path if needed

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// If user sends a message, process it
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['user_message'])) {
    $user_message = trim($_POST['user_message']);

    if (!empty($user_message)) {
        // Insert user message into database
        $stmt = $mysqli->prepare("INSERT INTO chatbot_responses (user_message) VALUES (?)");
        $stmt->bind_param("s", $user_message);
        $stmt->execute();

        // Get bot response (simulating a response here, but can be more dynamic)
        $bot_response = getBotResponse($user_message);

        // Insert bot response into database
        $stmt = $mysqli->prepare("UPDATE chatbot_responses SET bot_response = ? WHERE user_message = ?");
        $stmt->bind_param("ss", $bot_response, $user_message);
        $stmt->execute();
    }
}

// Function to simulate bot response (you can later pull this from the database)
function getBotResponse($message) {
    // For simplicity, hard-coded responses. This can be dynamic based on the database.
    if (strpos(strtolower($message), 'sveiki') !== false) {
        return 'Sveiki! Kā varu palīdzēt?';
    } elseif (strpos(strtolower($message), 'palīdzība') !== false) {
        return 'Es varu palīdzēt jums ar meditācijām vai motivāciju.';
    } else {
        return 'Piedodiet, es nesapratu jūsu jautājumu.';
    }
}

// Fetch all chat responses (user and bot) from the database
$stmt = $mysqli->query("SELECT * FROM chatbot_responses ORDER BY created_at ASC");
$messages = $stmt->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chat Bot</title>
    <link rel="stylesheet" href="../assets/style.css"> <!-- Add your styles -->
</head>
<body>
    <h1>Saruna ar tērzēšanas robotu</h1>

    <div id="chat-window">
        <div id="messages">
            <?php foreach ($messages as $message) : ?>
                <div>
                    <strong>Jūs:</strong> <?php echo htmlspecialchars($message['user_message']); ?>
                </div>
                <div>
                    <strong>Bots:</strong> <?php echo htmlspecialchars($message['bot_response']); ?>
                </div>
            <?php endforeach; ?>
        </div>

        <form method="POST">
            <input type="text" id="user-input" name="user_message" placeholder="Ieraksti ziņojumu..." />
            <button type="submit" id="send-btn">Sūtīt</button>
        </form>
    </div>

    <script src="../assets/app.js"></script>
        <button class="back" onclick="window.location.href='main.php'">Atpakaļ uz galveno lapu</button>
</body>
</html>
