// Funkcija, kas parāda meditāciju veidus
function showMeditationTypes() {
    // Paslēpjam citus sadalījumus
    document.getElementById("quotesSection").style.display = "none";
    document.getElementById("chatbotSection").style.display = "none";
    
    // Parādām meditāciju veidus
    document.getElementById("meditationsSection").style.display = "block";

    // Pārsūtam pieprasījumu uz serveri, lai saņemtu meditāciju veidus
    fetch('get_meditations.php')
        .then(response => response.json())
        .then(data => {
            let meditationList = document.getElementById("meditationList");
            meditationList.innerHTML = ""; // Notīram esošo sarakstu
            data.forEach(meditation => {
                let div = document.createElement('div');
                div.textContent = meditation.name;
                meditationList.appendChild(div);
            });
        })
        .catch(error => {
            console.error("Kļūda, iegūstot meditāciju:", error);
        });
}

// Funkcija, kas parāda motivējošus citātus
function showQuoteTypes() {
    // Paslēpjam citus sadalījumus
    document.getElementById("meditationsSection").style.display = "none";
    document.getElementById("chatbotSection").style.display = "none";
    
    // Parādām citātus
    document.getElementById("quotesSection").style.display = "block";

    // Pārsūtam pieprasījumu uz serveri, lai saņemtu citātus
    fetch('get_quotes.php')
        .then(response => response.json())
        .then(data => {
            let quotesList = document.getElementById("quotesList");
            quotesList.innerHTML = ""; // Notīram esošo sarakstu
            data.forEach(quote => {
                let div = document.createElement('div');
                div.textContent = quote.text;
                quotesList.appendChild(div);
            });
        })
        .catch(error => {
            console.error("Kļūda, iegūstot citātus:", error);
        });
}

// Funkcija, kas parāda sarunu ar botu
function showChatbot() {
    // Paslēpjam citus sadalījumus
    document.getElementById("meditationsSection").style.display = "none";
    document.getElementById("quotesSection").style.display = "none";
    
    // Parādām sarunu ar botu
    document.getElementById("chatbotSection").style.display = "block";
}
