CREATE DATABASE InnerQuest;
USE InnerQuest;

CREATE TABLE User (
    UserID INT AUTO_INCREMENT PRIMARY KEY,
    Username VARCHAR(50) NOT NULL UNIQUE,
    Password VARCHAR(255) NOT NULL,
    Status ENUM('Registered', 'Unregistered') NOT NULL
);

CREATE TABLE Mood (
    MoodID INT AUTO_INCREMENT PRIMARY KEY,
    UserID INT,
    Mood ENUM('Happy', 'Neutral', 'Sad') NOT NULL,
    FOREIGN KEY (UserID) REFERENCES User(UserID) ON DELETE CASCADE
);

CREATE TABLE MeditationType (
    MeditationTypeID INT AUTO_INCREMENT PRIMARY KEY,
    Name VARCHAR(100) NOT NULL,
    Description TEXT NOT NULL
);

CREATE TABLE Quote (
    QuoteID INT AUTO_INCREMENT PRIMARY KEY,
    Content TEXT NOT NULL,
    Type ENUM('Inspirational', 'Wisdom', 'Humor') NOT NULL
);

CREATE TABLE Chat (
    ChatID INT AUTO_INCREMENT PRIMARY KEY,
    UserID INT,
    Text TEXT NOT NULL,
    Timestamp DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (UserID) REFERENCES User(UserID) ON DELETE CASCADE
);
