
-- Izveido "InnerQuest" datu bāzi
CREATE DATABASE InnerQuest;
USE InnerQuest;

-- 1. Tabula: User
CREATE TABLE User (
    UserID INT AUTO_INCREMENT PRIMARY KEY,
    Username VARCHAR(50) UNIQUE NOT NULL,
    Password VARCHAR(50) NOT NULL,
    Email VARCHAR(100) UNIQUE NOT NULL,
    CreatedDate DATETIME DEFAULT CURRENT_TIMESTAMP
);

-- 2. Tabula: RegistrationLogin
CREATE TABLE RegistrationLogin (
    SessionID INT AUTO_INCREMENT PRIMARY KEY,
    UserID INT,
    LoginDate DATETIME NOT NULL,
    LogoutDate DATETIME,
    FOREIGN KEY (UserID) REFERENCES User(UserID)
);

-- 3. Tabula: Profile
CREATE TABLE Profile (
    ProfileID INT AUTO_INCREMENT PRIMARY KEY,
    UserID INT,
    Status VARCHAR(20) DEFAULT 'Active',
    Settings TEXT,
    FOREIGN KEY (UserID) REFERENCES User(UserID)
);

-- 4. Tabula: MoodRating
CREATE TABLE MoodRating (
    MoodID INT AUTO_INCREMENT PRIMARY KEY,
    UserID INT,
    MoodType ENUM('Happy', 'Neutral', 'Sad') NOT NULL,
    RatingDate DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (UserID) REFERENCES User(UserID)
);

-- 5. Tabula: Quotes
CREATE TABLE Quotes (
    QuoteID INT AUTO_INCREMENT PRIMARY KEY,
    UserID INT,
    QuoteType VARCHAR(50),
    Text TEXT NOT NULL,
    DownloadDate DATETIME,
    FOREIGN KEY (UserID) REFERENCES User(UserID)
);

-- 6. Tabula: Meditation
CREATE TABLE Meditation (
    MeditationID INT AUTO_INCREMENT PRIMARY KEY,
    UserID INT,
    MeditationType VARCHAR(50) NOT NULL,
    Instructions TEXT,
    VideoLink VARCHAR(200),
    DateAccessed DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (UserID) REFERENCES User(UserID)
);

-- 7. Tabula: Chatbot
CREATE TABLE Chatbot (
    ChatID INT AUTO_INCREMENT PRIMARY KEY,
    UserID INT,
    Message TEXT NOT NULL,
    Response TEXT,
    Timestamp DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (UserID) REFERENCES User(UserID)
);
