<?php
// Include the database connection
include('../includes/db.php');

// Start the session
session_start();

// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Check if a quote type is provided
$type = isset($_GET['type']) ? $_GET['type'] : null;

if ($type) {
    // Fetch a random quote of the given type
    $query = "SELECT quote, author FROM quotes WHERE type = ? ORDER BY RAND() LIMIT 1";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("s", $type);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result && $result->num_rows > 0) {
        $quoteData = $result->fetch_assoc();
        $quote = $quoteData['quote'];
        $author = $quoteData['author'];
    } else {
        $quote = "Citāts šajā kategorijā nav pieejams.";
        $author = "Nezināms autors";
    }
} else {
    header('Location: quotes_types.php'); // Redirect back if no type is selected
    exit();
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Citāts</title>
</head>
<body>
    <h1><?php echo htmlspecialchars($type); ?> Citāts</h1>
    <blockquote>
        <p><?php echo htmlspecialchars($quote); ?></p>
        <footer>— <?php echo htmlspecialchars($author); ?></footer>
    </blockquote>
    <button onclick="window.location.href='quotes_types.php'">Atpakaļ uz veidu izvēli</button>
</body>
</html>
