<?php
// Include database connection
include('../includes/db.php');  // Adjust the path if necessary

// Check if meditation_id is passed through URL
if (isset($_GET['meditation_id'])) {
    $meditation_id = $_GET['meditation_id'];

    // Query to get details of the meditation based on its ID
    $query = "SELECT * FROM meditations WHERE meditation_id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $meditation_id); // Binding the meditation ID to the query
    $stmt->execute();
    $result = $stmt->get_result();

    // Check if the meditation is found
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        echo "<h1>" . htmlspecialchars($row['name']) . "</h1>"; // Display the name
        echo "<p>" . nl2br(htmlspecialchars($row['description'])) . "</p>"; // Display the description
    } else {
        echo "Meditation not found.";
    }

    // Close the statement and connection
    $stmt->close();
} else {
    echo "No meditation ID provided.";
}

$conn->close();
?>
