<?php
// Iekļaujam datu bāzes savienojumu
include('../includes/db.php');

// Sākot sesiju
session_start();

// Pārbauda, vai lietotājs jau ir pieteicies
if (isset($_SESSION['user_id'])) {
    header("Location: main.php");
    exit();
}

// Pārbauda, vai forma ir nosūtīta
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Iegūst ievadītos datus
    $username = $_POST['username'];
    $password = $_POST['password'];

    // SQL vaicājums, lai iegūtu lietotāju ar norādīto lietotājvārdu
    $query = "SELECT * FROM users WHERE username = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();

    // Pārbauda, vai lietotājs ir atrasts
    if ($result->num_rows > 0) {
        $user = $result->fetch_assoc();

        // Pārbauda, vai parole sakrīt ar saglabāto paroli
        if (password_verify($password, $user['password_hash'])) {
            // Pieteikšanās veiksmīga, saglabā lietotāja ID sesijā
            $_SESSION['user_id'] = $user['user_id'];
            header("Location: main.php");
            exit();
        } else {
            // Nepareiza parole
            $error_message = "Nepareiza parole!";
        }
    } else {
        // Lietotājs netika atrasts
        $error_message = "Lietotājs ar šādu lietotājvārdu netika atrasts!";
    }
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pieslēgties</title>
    <link rel="stylesheet" href="../assets/style.css">
</head>
<body>
    <h1>Pieslēgties</h1>
    
    <?php
    // Ja ir kļūda, parādām ziņojumu
    if (isset($error_message)) {
        echo "<p style='color: red;'>$error_message</p>";
    }
    ?>
    
    <!-- Login form -->
    <form action="login.php" method="POST">
        <label for="username">Lietotājvārds:</label>
        <input type="text" name="username" required>
        <br>
        <label for="password">Parole:</label>
        <input type="password" name="password" required>
        <br>
        <button type="submit">Pieslēgties</button>
    </form>

    <!-- Registration link -->
    <p>Nav konta? <a href="register.php">Reģistrējieties šeit</a>.</p>
</body>
</html>
