-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Server version:               10.4.32-MariaDB - mariadb.org binary distribution
-- Server OS:                    Win64
-- HeidiSQL Version:             12.6.0.6765
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


-- Dumping database structure for kval_ivanova
CREATE DATABASE IF NOT EXISTS `kval_ivanova` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci */;
USE `kval_ivanova`;

-- Dumping structure for table kval_ivanova.chat_logs
CREATE TABLE IF NOT EXISTS `chat_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `user_message` text NOT NULL,
  `bot_response` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `chat_logs_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table kval_ivanova.chat_logs: ~2 rows (approximately)
INSERT INTO `chat_logs` (`id`, `user_id`, `user_message`, `bot_response`, `created_at`) VALUES
	(1, 1, 'How can I feel better today?', 'Try practicing mindfulness to center yourself.', '2024-11-21 06:55:21'),
	(2, 1, 'Give me a motivational quote.', 'Believe in yourself and all that you are.', '2024-11-21 06:55:21');

-- Dumping structure for table kval_ivanova.meditations
CREATE TABLE IF NOT EXISTS `meditations` (
  `meditation_id` int(11) NOT NULL AUTO_INCREMENT,
  `description` text NOT NULL,
  `name` varchar(50) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`meditation_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table kval_ivanova.meditations: ~3 rows (approximately)
INSERT INTO `meditations` (`meditation_id`, `description`, `name`, `created_at`) VALUES
	(13, 'A relaxation technique focusing on slow, deep breathing.', 'Deep Breathing', '2024-11-21 10:01:38'),
	(14, 'A meditation technique that involves focusing on the present moment.', 'Mindfulness', '2024-11-21 10:01:38'),
	(15, 'A type of meditation where a guide helps the practitioner focus.', 'Guided Meditation', '2024-11-21 10:01:38');

-- Dumping structure for table kval_ivanova.quotes
CREATE TABLE IF NOT EXISTS `quotes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `quote` text NOT NULL,
  `author` varchar(255) NOT NULL,
  `type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table kval_ivanova.quotes: ~3 rows (approximately)
INSERT INTO `quotes` (`id`, `quote`, `author`, `type`) VALUES
	(1, 'The only way to do great work is to love what you do.', 'Steve Jobs', 'Motivational'),
	(2, 'Success is not the key to happiness. Happiness is the key to success.', 'Albert Schweitzer', 'Motivational'),
	(3, 'In the middle of every difficulty lies opportunity.', 'Albert Einstein', 'Inspirational');

-- Dumping structure for table kval_ivanova.users
CREATE TABLE IF NOT EXISTS `users` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `password_hash` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`user_id`) USING BTREE,
  UNIQUE KEY `username` (`username`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table kval_ivanova.users: ~10 rows (approximately)
INSERT INTO `users` (`user_id`, `username`, `password_hash`, `email`, `created_at`) VALUES
	(1, 'testuser', '$2y$10$E19vlKslpENh8rDUSQid9O4LsG/hznI9jwG8.KUiI8nYqurHdPu3u', 'test@example.com', '2024-11-21 06:55:21'),
	(2, 'laura', '$2y$10$M/9NLoKkDoU82wj9sz4XveTOP3yaimrLoXj30sXV3FVxdlipNdQpW', 'lauraivanova11@gmail.com', '2024-11-21 06:56:06'),
	(4, 'laurai', '$2y$10$CbkTFOXTzv389Y/7JIOhIOHSRQS1qsknwVIgBPHnTKcJR8yuu1i.i', 'laurai@gmail.com', '2024-11-21 06:58:49'),
	(5, 'ivanova', '$2y$10$fO6zrbHq8fxH8K7ciZuvye4WM33k0MBzBA8VZ8IOdfe.DOdx0a10G', 'ivanova@gmail.com', '2024-11-21 07:02:10'),
	(6, 'ne123', '$2y$10$V0B1ETc5HVu4/7/13uah7es.iU2Fl81n2HuYF06xWpcwYsErn94LS', 'ne@inbox.lv', '2024-11-21 07:09:24'),
	(7, 'a', '$2y$10$gcmkZN42LkzuoEKN9RgTcu0nYulF4IpbeV3DCi9eUbKhqxPH4Tooa', 'a@inbox.lv', '2024-11-21 07:11:42'),
	(8, 'abc', '$2y$10$CFCVwO9.dDsa/6.gJ0SV0uBoEuR5QO5MiVuw9GurDOkJAoayITpYK', 'abc@inbox.lv', '2024-11-21 09:46:17'),
	(10, 'laur', '$2y$10$eeJGyV5zi6sD/DIgw..p3exEaK28USq/fb9.ioiNGX/bYjCnuING.', 'laur@inbox.lv', '2024-11-21 09:47:55'),
	(11, '123', '$2y$10$CqAyE59fxO1jIHjXx/4clOmPfmM/Z6BHjx7KLWpzq84NhR7byCg5K', '123@inbox.lv', '2024-11-21 09:52:46'),
	(12, 'lauraivanova', '$2y$10$d1lScUe7r0mvdgalkLOKBeQZEkKc29iHteJK4rmRbthWEbDp5lmDO', 'lauraivanova@gmail.com', '2024-11-21 11:58:49');

/*!40103 SET TIME_ZONE=IFNULL(@OLD_TIME_ZONE, 'system') */;
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IFNULL(@OLD_FOREIGN_KEY_CHECKS, 1) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40111 SET SQL_NOTES=IFNULL(@OLD_SQL_NOTES, 1) */;
