<?php
// Sākam sesiju, lai piekļūtu sesijas datiem (piemēram, lietotāja ID)
session_start();
// Iekļaujam datubāzes savienojumu
include('../includes/db.php');


// Pārbaudām, vai lietotājs ir pieteicies un vai POST pieprasījumā ir nosūtīts 'rating'
if (!isset($_SESSION['user_id']) || !isset($_POST['rating'])) {
      // Ja kāda no prasībām nav izpildīta, novirzam lietotāju uz galveno lapu
    header('Location: main.php');
    exit();
}

// Saglabājam lietotāja ID no sesijas
$user_id = $_SESSION['user_id'];
// Pārveidojam saņemto vērtējumu par veselu skaitli
$rating = (int)$_POST['rating'];
// Sagatavojam šodienas datumu formātā 'YYYY-MM-DD'
$today = date('Y-m-d');

// Pārbauda, vai šodien jau ir iesniegts vērtējums
$stmt = $mysqli->prepare("SELECT * FROM mood_ratings WHERE user_id = ? AND created_at = ?");
$stmt->bind_param("is", $user_id, $today);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    // Ja nav neviena ieraksta šai dienai, ievietojam jaunu vērtējumu datubāzē
    $stmt = $mysqli->prepare("INSERT INTO mood_ratings (user_id, rating, created_at) VALUES (?, ?, ?)");
    $stmt->bind_param("iis", $user_id, $rating, $today);
    $stmt->execute();
}

// Pēc procesa pabeigšanas novirzam lietotāju atpakaļ uz galveno lapu
header('Location: main.php');
exit();
