<?php
// Iekļauj datubāzes pieslēguma failu
include('../includes/db.php');
// Sāk sesiju, lai pārbaudītu lietotāja autentifikāciju
session_start();


// Ja lietotājs nav pieteicies, novirza uz pieslēgšanās lapu
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Iegūst unikālos citātu veidus no datubāzes
$query = "SELECT DISTINCT type FROM quotes";
$result = $mysqli->query($query);

// Izveido tukšu masīvu, kur glabās visus atrastos citātu veidus
$types = [];
if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $types[] = $row['type'];
    }
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Citātu Veidi</title>
      <!-- Stila lapa -->
    <link rel="stylesheet" href="../assets/style.css">
</head>
<body>
       <!-- Dublikāts <body> tags -->
    <body class="quotes-page">
 <div class="container">
<h1>Izvēlies citātu veidu!</h1>
<p>Šajā lapā tu vari izvēlēties citātu veidu, kas vislabāk atbilst tavai noskaņai vai vajadzībām. Katrs citātu veids piedāvā iedvesmojošas domas un atziņas no dažādām dzīves jomām. Uzklikšķini uz attēla vai nosaukuma, lai apskatītu citātus konkrētajā kategorijā!</p>

<?php if (count($types) > 0): ?>
    <div class="image-buttons">
        <?php foreach ($types as $type): ?>
            <?php
              // Pārvērš veida nosaukumu par atbilstošu attēla faila nosaukumu
                $imageName = strtolower(str_replace(' ', '_', $type)) . '.png';
                $imagePath = '../assets/images/' . $imageName;
            ?>
            <div class="image-button-wrapper">
                <?php if (file_exists($imagePath)): ?>
                      <!-- Ja attēls eksistē, parāda attēlu kā klikšķināmu pogu -->
                    <img class="image-button" src="<?php echo $imagePath; ?>" alt="<?php echo htmlspecialchars($type); ?>" onclick="window.location.href='quotes.php?type=<?php echo urlencode($type); ?>'">
                <?php else: ?>
                    <!-- Ja attēla nav, parāda vienkāršu pogu ar nosaukumu -->
                    <button class="image-button" onclick="window.location.href='quotes.php?type=<?php echo urlencode($type); ?>'"><?php echo htmlspecialchars($type); ?></button>
                <?php endif; ?>
                   <!-- Parāda citāta veida nosaukumu -->
                <p><?php echo htmlspecialchars($type); ?></p>
            </div>
        <?php endforeach; ?>
    </div>

     <!-- Ja nav neviena pieejama citātu veida -->
<?php else: ?>
    <p>Nav pieejami citātu veidi.</p>
<?php endif; ?>
<br><br>

<!-- Poga, lai atgrieztos uz galveno lapu -->
<button class="logout" onclick="window.location.href='main.php'">Atpakaļ uz galveno lapu</button>
  </div>
</body>
</html>
