<?php
// Iekļaujam datu bāzes savienojumu, lai piekļūtu nepieciešamajiem datiem
include('../includes/db.php');

// Sākam sesiju, lai pārbaudītu, vai lietotājs ir pieteicies
session_start();

// Pārbaudām, vai lietotājs ir autentificējies
if (!isset($_SESSION['user_id'])) {
    // Ja lietotājs nav pieteicies, novirzām uz pieteikšanās lapu
    header('Location: login.php');
    exit();
}

// Pārbaudām, vai GET pieprasījumā ir norādīts citātu veids
$type = isset($_GET['type']) ? $_GET['type'] : null;

if ($type) {
    // Iekļaujam SQL vaicājumu, kas izvēlas visus citātus pēc veida
    include('sql/quotes.php');
    
    // Sagatavojam un izpildām vaicājumu ar parametru
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param("s", $type);
    $stmt->execute();
    $result = $stmt->get_result();
} else {
    // Ja nav norādīts citātu veids, novirzām lietotāju atpakaļ uz citātu veidu lapu
    header('Location: quotes_types.php'); 
    exit();
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="../assets/style.css">
    <title>Citāti</title>
</head>
<body>
      <div class="container">
          <!-- Virsraksts ar atlasītā citātu veida nosaukumu -->
    <h1>Citāti no kategorijas: <?php echo htmlspecialchars($type); ?></h1>

    <?php
    // Pārbaudām, vai ir atrasti citāti
    if ($result && $result->num_rows > 0) {
        // Iterējam cauri visiem citātiem un izvadām katru atsevišķi
        while ($quoteData = $result->fetch_assoc()) {
            $quote = $quoteData['quote'];
            $author = $quoteData['author'];

             // Izvadām citātu un tā autoru, izmantojot HTML blokāku
           echo "
            <div class='quote-block'>
                <blockquote>
                    <p>" . htmlspecialchars($quote) . "</p>
                    <footer>
                        — " . htmlspecialchars($author) . "
                        <!-- Poga citāta lejupielādei -->
                        <button class='download-button' onclick=\"window.location.href='download_quote.php?quote=" . urlencode($quote) . "'\">Lejupielādēt</button>
                    </footer>
                </blockquote>
                <hr>
            </div>";
    }
} else {
    // Ja nav neviena citāta šajā kategorijā
    echo "<p>Nav citātu šajā kategorijā.</p>";
}
?>
  <!-- Poga, lai atgrieztos pie citātu veidu izvēles -->
    <button class="logout" onclick="window.location.href='quotes_types.php'">Atpakaļ uz veidu izvēli</button>
</div>
</body>
</html>
