<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Meditācijas veidi</title>
    <link rel="stylesheet" href="../assets/style.css">
</head>
<body>
    <body class="meditation-page">
<div class="container">
<h1>Izvēlies meditācijas veidu!</h1>
<p>Šajā lapā tu vari izvēlēties sev piemērotāko meditācijas veidu. Katrs attēlots variants piedāvā unikālu pieeju iekšējā miera, līdzsvara un koncentrēšanās uzlabošanai. Uzklikšķini uz attēla vai nosaukuma, lai uzzinātu vairāk un sāktu meditāciju!</p>


<?php
// Iekļaujam datubāzi
include('../includes/db.php');

// Iekļauj SQL vaicājumu, kas iegūst visus meditācijas veidus
include('sql/meditation_types.php');
// Izpilda SQL vaicājumu
$result = $mysqli->query($query);

// Ja vaicājuma rezultātā ir atrastas meditācijas
if ($result->num_rows > 0) {
    echo '<div class="image-buttons">';

     // Cikls caur katru meditācijas rindu
    while($row = $result->fetch_assoc()) {
          // Izveido attēla faila nosaukumu no meditācijas nosaukuma (mazie burti, atstarpes aizvietotas ar "_")
        $imageName = strtolower(str_replace(' ', '_', $row['name'])) . '.png';
        $imagePath = '../assets/images/' . $imageName;

          // Iegūst meditācijas ID un nosaukumu
        $meditationId = $row['meditation_id'];
        $name = htmlspecialchars($row['name']);

        echo '<div class="image-button-wrapper">';

         // Ja attēla fails eksistē norādītajā vietā, rāda attēlu kā pogu
        if (file_exists($imagePath)) {
            echo '<img class="image-button" src="' . $imagePath . '" alt="' . $name . '" onclick="window.location.href=\'meditation_info.php?meditation_id=' . $meditationId . '\'">';
        } else {
                 // Ja attēls nav atrasts, rāda pogu ar tekstu
            echo '<button class="image-button" onclick="window.location.href=\'meditation_info.php?meditation_id=' . $meditationId . '\'">' . $name . '</button>';
        }
        // Parāda meditācijas nosaukumu zem attēla vai pogas
        echo '<p>' . $name . '</p>';
        echo '</div>';
    }
    echo '</div>';
} else {
    // Ja nav neviena meditācijas ieraksta
    echo '<p>No meditation types found.</p>';
}

// Aizver datubāzes savienojumu
$mysqli->close();
?>

<!-- Atpakaļ uz galveno lapu -->
<br><br>
<button class="logout" onclick="window.location.href='main.php'">Atpakaļ uz galveno lapu</button>
</div>
</body>
</html>
