<?php
// Sāk sesiju, lai piekļūtu sesijas mainīgajiem (lietotāja datiem)
session_start();
// Iekļaujam datubāzes savienojuma failu
include('../includes/db.php');

// Pārbaudām, vai ir norādīts meditācijas ID URL parametros (?meditation_id=...)
if (isset($_GET['meditation_id'])) {
    $meditation_id = $_GET['meditation_id'];

     // Sagatavojam SQL vaicājumu, lai atlasītu meditācijas informāciju pēc ID
    $stmt = $mysqli->prepare("SELECT name, description, link FROM meditations WHERE meditation_id = ?");
    $stmt->bind_param("i", $meditation_id);
    $stmt->execute();
    $result = $stmt->get_result();

     // Ja atrasta meditācija
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
?>


<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($row['name']); ?></title>
    <link rel="stylesheet" href="../assets/style.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body>

    <div class="container">
  <!-- Meditācijas nosaukums un apraksts -->
    <h1><?php echo htmlspecialchars($row['name']); ?></h1>
    <p><?php echo nl2br(htmlspecialchars($row['description'])); ?></p>

     <!-- Ja ir pievienots video links, rādām iframe -->
    <?php if (!empty($row['link'])): ?>
        <iframe width="560" height="315" src="<?php echo htmlspecialchars($row['link']); ?>"
            frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen>
        </iframe>
    <?php endif; ?>

    <br><br>

     <!-- Ja lietotājs ir pieteicies, rādām formu, lai pievienotu meditāciju kolekcijai -->
    <?php if (isset($_SESSION['user_id'])): ?>
        <form id="add-to-favorites-form" action="add_to_favorites.php" method="POST">
            <input type="hidden" name="meditation_id" value="<?php echo $meditation_id; ?>">
            <button type="submit" class="pink-button">Pievienot kolekcijai</button>
        </form>
        <div id="response-message"></div>
    <?php else: ?>
        <!-- Ja nav pieteicies, aicinām pieteikties -->
        <p>Lūdzu, pieteikties, lai pievienotu meditāciju kolekcijai.</p>
    <?php endif; ?>
   <!-- Atpakaļ poga -->
    <button class="logout" onclick="window.location.href='meditation_types.php'">Atpakaļ</button>
   </div>

   <!-- jQuery skripts, lai forma tiktu apstrādāta caur AJAX -->
    <script>
        $(document).ready(function() {
            $('#add-to-favorites-form').submit(function(event) {
                event.preventDefault();

                // Atspējojam pogu, lai novērstu atkārtotu nospiešanu
                $('button[type="submit"]').prop('disabled', true).text('Pievienots...');

                $.ajax({
                    url: 'add_to_favorites.php',
                    type: 'POST',
                    data: $(this).serialize(),
                    success: function(response) {
                        $('#response-message').html(response); // Rāda atbildi
                    },
                    error: function() {
                        $('#response-message').html("Kļūda pievienojot meditāciju.");
                    },
                    complete: function() {
                        // Atjaunojam pogu pēc procesa pabeigšanas
                        $('button[type="submit"]').prop('disabled', false).text('Pievienot kolekcijai');
                    }
                });
            });
        });
    </script>
</body>
</html>
<?php
    } else {
        // Ja meditācija nav atrasta pēc ID
        echo "Meditācija nav atrasta.";
    }
    $stmt->close();
} else {
        // Ja URL nav norādīts meditācijas ID
    echo "Nav norādīts meditācijas ID.";
}
// Aizveram datubāzes savienojumu
$mysqli->close();
?>
