<?php
// Iekļaujam datu bāzes savienojumu
include('../includes/db.php'); // Adjust the path if necessary

// Sāk sesiju, lai pārvaldītu lietotāja pieteikšanos
session_start();

// Pārbaudām, vai lietotājs ir pieteicies
if (!isset($_SESSION['user_id'])) {
    // Ja lietotājs nav pieteicies, novirzām uz pieteikšanās lapu
    header('Location: login.php');
    exit();
}

// Iegūstam pieteikušā lietotāja ID no sesijas mainīgā
$user_id = $_SESSION['user_id'];

// Sagatavojam SQL vaicājumu lietotāja informācijas iegūšanai
include('sql/main.php');
$stmt = $mysqli->prepare($query); 
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

// Aprēķinām datumu, kas būs saistīts ar citātu (tiks izmantots tikai mēnesis un diena)
$today = date('md'); // Iegūst šodienas datumu formātā md (piemēram: 0421)

// Izveidojam SQL vaicājumu, lai atlasītu citātu, kas saistīts ar šo dienu
// Tiks izmantots šodienas datums, lai atlasītu citātu
$query = "
    SELECT quote, author 
    FROM quotes 
    ORDER BY ABS(UNIX_TIMESTAMP(CONCAT('2025-', SUBSTRING('$today',1,2), '-', SUBSTRING('$today',3,4))) - UNIX_TIMESTAMP(NOW())) 
    LIMIT 1
";

// Sagatavojam un izpildām vaicājumu
$stmt = $mysqli->prepare($query);
$stmt->execute();
$result = $stmt->get_result();

// Pārbaudām, vai ir atrasts citāts
if ($result && $result->num_rows > 0) {
    $quoteData = $result->fetch_assoc();
    $quote = $quoteData['quote'];
    $author = $quoteData['author'];
} else {
    // Ja nav atrasts citāts konkrētajam datumam, izvēlamies nejaušu citātu
    $query = "SELECT quote, author FROM quotes ORDER BY RAND() LIMIT 1";
    $result = $mysqli->query($query);
    $quoteData = $result->fetch_assoc();
    $quote = $quoteData['quote'];
    $author = $quoteData['author'];
}

// Pārbaudām, vai lietotājs jau ir novērtējis šodienu
$today_rating = null;
$checkRatingQuery = "SELECT rating FROM mood_ratings WHERE user_id = ? AND DATE(created_at) = CURDATE()";
$stmt = $mysqli->prepare($checkRatingQuery);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result && $result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $today_rating = $row['rating']; // Ja ir vērtējums, mēs to saglabājam
}

// Pārbaude, vai tika nosūtīts jauns vērtējums
if (isset($_POST['rating']) && !$today_rating) {
    $rating = $_POST['rating'];
    $insertQuery = "INSERT INTO mood_ratings (user_id, rating) VALUES (?, ?)";
    $stmt = $mysqli->prepare($insertQuery);
    $stmt->bind_param("ii", $user_id, $rating);
    $stmt->execute();
    $today_rating = $rating; // Saglabājam vērtējumu, lai uzrādītu
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Main Page</title>
    
    <!-- Pievienojam CSS stila failu -->
    <link rel="stylesheet" href="../assets/style.css">
</head>
<body>
     <div class="container">
    <!-- Lietotāja sveiciens ar dinamisku lietotājvārdu -->
    <h1>Sveiki, <?php echo htmlspecialchars($user['username']); ?>!</h1>
   

<div class="image-buttons">
      <div class="image-button-wrapper">
        
    <button onclick="window.location.href='meditation_types.php'">
        <img src="../assets/meditacija.jpg" alt="Meditācijas veidi" class="image-button" />
    </button>
      <p>Meditācijas veidi</p>
        </div>
        <div class="image-button-wrapper">
    <button onclick="window.location.href='quotes.php'">
        <img src="../assets/citati.jpg" alt="Motivējoši citāti" class="image-button" />
    </button>
       <p>Motivējoši citāti</p>
       </div>
         <div class="image-button-wrapper">
    <button onclick="window.location.href='chat.php'">
        <img src="../assets/terzesana.jpg" alt="Saruna ar tērzēšanas robotu" class="image-button"/>
    </button>
      <p>Tērzēšanas robots</p>
      </div>
        <div class="image-button-wrapper">
    <button onclick="window.location.href='favorite_meditations.php'">
        <img src="../assets/favoriti.jpg" alt="Skatīt manu kolekciju" class="image-button"/>
    </button>
           <p>Skatīt manu kolekciju</p>
          
    </div>
</div>
    <!-- Šodienas citāts zem pogām -->
    <div style="margin-top: 20px;">
        <h2>Šodienas citāts</h2>
        <blockquote>
            <p><?php echo htmlspecialchars($quote); ?></p>
            <footer>— <?php echo htmlspecialchars($author); ?></footer>
        </blockquote>
    </div>

    <!-- Noskaņojuma vērtējums -->
    <h3>Kā tu šodien jūties?</h3>

    <?php if ($today_rating): ?>
        <!-- Ja lietotājs jau ir novērtējis sevi, parādām viņa vērtējumu kā tekstu -->
        <p>Tu novērtēji sevi ar: <?php echo $today_rating; ?></p>
    <?php else: ?>
        <!-- Ja lietotājs vēl nav novērtējis sevi, parādām pogas -->
        <form method="post">
            <?php for ($i = 1; $i <= 10; $i++): ?>
               <button type="submit" name="rating" value="<?php echo $i; ?>" class="rating"><?php echo $i; ?></button>

            <?php endfor; ?>
        </form>
    <?php endif; ?>
    <form action="log_out.php" method="post" style="margin-top: 20px;">
            <!-- Poga, lai izrakstītos -->
    <button type="submit" class="izrakstities">Izrakstīties</button>
</form>
  </div>

</body>
</html>
