<?php
// Iekļaujam datu bāzes savienojumu
include('../includes/db.php');

// Sākot sesiju
session_start();

// Pārbauda, vai lietotājs jau ir pieteicies
if (isset($_SESSION['user_id'])) {
    // Ja lietotājs ir pieteicies, pārsūtām viņu uz galveno lapu
    header("Location: main.php");
    exit();
}

// Pārbaudām, vai pieteikšanās forma ir nosūtīta ar POST metodi
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
      // Iegūstam lietotāja ievadītos datus no formas
    $username = $_POST['username'];
    $password = $_POST['password'];

    // SQL vaicājums, lai iegūtu lietotāju ar norādīto lietotājvārdu
    include('sql/login.php');
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();

    
    // Pārbaudām, vai datu bāzē ir atrasts lietotājs ar ievadīto lietotājvārdu
    if ($result->num_rows > 0) {
        $user = $result->fetch_assoc();

         // Salīdzinām ievadīto paroli ar hashēto paroli datu bāzē
        if (password_verify($password, $user['password_hash'])) {
                // Ja parole sakrīt, iestatām sesijas mainīgo ar lietotāja ID
            $_SESSION['user_id'] = $user['user_id'];
            header("Location: main.php");
            exit();
        } else {
            // Ja parole ir nepareiza, izvadām kļūdas ziņojumu
            $error_message = "Nepareiza parole!";
        }
    } else {
         // Ja lietotājs ar šādu lietotājvārdu nav atrasts
        $error_message = "Lietotājs ar šādu lietotājvārdu netika atrasts!";
    }
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pieslēgties</title>
       <!-- Ielādējam CSS stilu failu -->
    <link rel="stylesheet" href="../assets/style.css">

    <script>
    // Ja PHP mainīgais $error_message satur kļūdas ziņojumu, parādām popup
    <?php if (!empty($error_message)): ?>
        alert("<?php echo $error_message; ?>");
    <?php endif; ?>
</script>


</head>
<body>
    <div class="container">
    <div class="login-box">
        <h1>Pieslēgties</h1>

          <!-- Ja ir kļūdas ziņojums, parādām to virs formas -->
        <?php if (isset($error_message)): ?>
            <p class="error-message"><?php echo $error_message; ?></p>
        <?php endif; ?>

             <!-- Pieslēgšanās forma -->
        <form action="login.php" method="POST">
            <label for="username">Lietotājvārds:</label>
            <input type="text" id="username" name="username" required />

            <label for="password">Parole:</label>
            <input type="password" id="password" name="password" required />

            <div class="button-container">
                <button type="submit">Pieslēgties</button>
            </div>
        </form>

        <!-- Saite uz reģistrācijas lapu, ja lietotājam vēl nav konta -->
        <p class="register-link">Nav konta? <a href="register.php">Reģistrējieties šeit</a>.</p>
    </div>
</div>
</body>
</html>
