<?php
// Iekļaujam datu bāzes savienojumu
include('../includes/db.php');

// Sāk sesiju, lai pārvaldītu lietotāja pieteikšanos
session_start();

// Pārbaudām, vai lietotājs ir pieteicies
if (!isset($_SESSION['user_id'])) {
    // Ja lietotājs nav pieteicies, novirzām uz pieteikšanās lapu
    header('Location: login.php');
    exit();
}

// Iegūstam pieteikušā lietotāja ID no sesijas mainīgā
$user_id = $_SESSION['user_id'];

// Sagatavojam SQL vaicājumu lietotāja informācijas iegūšanai
include('sql/main.php');
$stmt = $mysqli->prepare($query); 
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

// Aprēķinām datumu, kas būs saistīts ar citātu (tiks izmantots tikai mēnesis un diena)
$today = date('md'); // Iegūst šodienas datumu formātā md (piemēram: 0421)

// Izveidojam SQL vaicājumu, lai atlasītu citātu, kas saistīts ar šo dienu
$query = "
    SELECT quote, author 
    FROM quotes 
    ORDER BY ABS(UNIX_TIMESTAMP(CONCAT('2025-', SUBSTRING('$today',1,2), '-', SUBSTRING('$today',3,4))) - UNIX_TIMESTAMP(NOW())) 
    LIMIT 1
";

// Sagatavojam un izpildām vaicājumu
$stmt = $mysqli->prepare($query);
$stmt->execute();
$result = $stmt->get_result();

// Pārbaudām, vai ir atrasts citāts
if ($result && $result->num_rows > 0) {
    $quoteData = $result->fetch_assoc();
    $quote = $quoteData['quote'];
    $author = $quoteData['author'];
} else {
    // Ja nav atrasts citāts konkrētajam datumam, izvēlamies nejaušu citātu
    $query = "SELECT quote, author FROM quotes ORDER BY RAND() LIMIT 1";
    $result = $mysqli->query($query);
    $quoteData = $result->fetch_assoc();
    $quote = $quoteData['quote'];
    $author = $quoteData['author'];
}

// Pārbaudām, vai lietotājs jau ir novērtējis šodienu
$today_rating = null;
$checkRatingQuery = "SELECT rating FROM mood_ratings WHERE user_id = ? AND DATE(created_at) = CURDATE()";
$stmt = $mysqli->prepare($checkRatingQuery);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result && $result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $today_rating = $row['rating']; // Ja ir vērtējums, mēs to saglabājam
}

// Pārbaude, vai tika nosūtīts jauns vērtējums
if (isset($_POST['rating']) && !$today_rating) {
    $rating = $_POST['rating'];
    $insertQuery = "INSERT INTO mood_ratings (user_id, rating) VALUES (?, ?)";
    $stmt = $mysqli->prepare($insertQuery);
    $stmt->bind_param("ii", $user_id, $rating);
    $stmt->execute();
    $today_rating = $rating; // Saglabājam vērtējumu, lai uzrādītu
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Main Page</title>
    <link rel="stylesheet" href="../assets/style.css">
</head>
<body>
    <!-- Lietotāja sveiciens ar dinamisku lietotājvārdu -->
    <h1>Sveiki, <?php echo htmlspecialchars($user['username']); ?>!</h1>

    <!-- Navigācijas pogas uz dažādām sadaļām -->
    <button onclick="window.location.href='meditation_types.php'">Meditācijas veidi</button>
    <button onclick="window.location.href='quotes.php'">Motivējoši citāti</button>
    <button onclick="window.location.href='chat.php'">Saruna ar tērzēšanas robotu</button>
    <!-- Pievienojam pogu, kas ved uz kolekcijas lapu -->
    <button onclick="window.location.href='favorite_meditations.php'">Skatīt manu kolekciju</button>

    <form action="log_out.php" method="post" style="margin-top: 20px;">
        <button type="submit">Izrakstīties</button>
    </form>

    <!-- Šodienas citāts zem pogām -->
    <div style="margin-top: 20px;">
        <h2>Šodienas citāts</h2>
        <blockquote>
            <p><?php echo htmlspecialchars($quote); ?></p>
            <footer>— <?php echo htmlspecialchars($author); ?></footer>
        </blockquote>
    </div>

    <h3>Kā tu šodien jūties?</h3>

    <?php if ($today_rating): ?>
        <!-- Ja lietotājs jau ir novērtējis sevi, parādām viņa vērtējumu kā tekstu -->
        <p>Tu novērtēji sevi ar: <?php echo $today_rating; ?></p>
    <?php else: ?>
        <!-- Ja lietotājs vēl nav novērtējis sevi, parādām pogas -->
        <form method="post">
            <?php for ($i = 1; $i <= 10; $i++): ?>
                <button type="submit" name="rating" value="<?php echo $i; ?>"><?php echo $i; ?></button>
            <?php endfor; ?>
        </form>
    <?php endif; ?>

</body>
</html>
