<?php
// Sāk sesiju, lai piekļūtu $_SESSION mainīgajiem
session_start();
// Iekļauj datubāzes savienojuma failu
include('../includes/db.php');

// Pārbauda, vai lietotājs ir pieteicies (ja nav — pāradresē uz login lapu)
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Iegūst lietotāja ID no sesijas
$user_id = $_SESSION['user_id'];

// Iegūst iecienītās meditācijas no datubāzes, pievienojot meditāciju datus no meditations tabulas
$stmt = $mysqli->prepare("
    SELECT m.name, m.description, m.link 
    FROM favorite_meditations fm 
    JOIN meditations m ON fm.meditation_id = m.meditation_id 
    WHERE fm.user_id = ?
");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Jūsu iecienītās meditācijas</title>
       <!-- Pievienojam stilu lapu -->
    <link rel="stylesheet" href="../assets/style.css" />
</head>
<body>
<div class="container">
    <h1>Jūsu iecienītās meditācijas</h1>

    <?php
     // Ja ir atrasti rezultāti — izvada katru iecienīto meditāciju
    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            ?>
            <div class="meditation-item">
                <!-- Meditācijas nosaukums -->
                <h2><?php echo htmlspecialchars($row['name']); ?></h2>
                <!-- Meditācijas apraksts (saglabājot jaunas rindas) -->
                <p><?php echo nl2br(htmlspecialchars($row['description'])); ?></p>

                 <!-- Ja ir pievienots video saite, parādīt YouTube video -->
                <?php if (!empty($row['link'])): ?>
                    <div class="meditation-video">
                        <iframe width="560" height="315" src="<?php echo htmlspecialchars($row['link']); ?>" frameborder="0" allowfullscreen></iframe>
                    </div>
                <?php endif; ?>
            </div>
             <!-- Dekoratīvs sadalītājs starp meditācijām -->
              <hr class="meditation-divider">
            <?php
        }
    } else {
         // Ja nav iecienīto meditāciju
        echo "<p>Nav pievienotas iecienītās meditācijas.</p>";
    }
  // Aizver vaicājumu un savienojumu ar datubāzi
    $stmt->close();
    $mysqli->close();
    ?>
 <!-- Poga atgriezties uz galveno lapu -->
    <button class="logout" onclick="window.location.href='main.php'">Atpakaļ uz galveno lapu</button>
</div>
</body>
</html>
