<?php
// Sāk sesiju, lai varētu izmantot $_SESSION mainīgos
session_start();
// Iekļauj datubāzes pieslēgšanās failu
include('../includes/db.php');

// Ja lietotājs nav pieteicies, pāradresē uz pieteikšanās lapu
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Iegūst lietotāja ID no sesijas
$user_id = $_SESSION['user_id'];


// Ja forma ir iesniegta (POST metode) un ir aizpildīts lietotāja ziņojums
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['user_message'])) {
    $user_message = trim($_POST['user_message']);

 // Ja ziņojums nav tukšs
    if (!empty($user_message)) {
            // Iegūst bota atbildi
        $bot_response = getBotResponse($mysqli, $user_message);

             // Saglabā sarunu datubāzē
        $stmt = $mysqli->prepare("INSERT INTO chat_logs (user_id, user_message, bot_response) VALUES (?, ?, ?)");
        $stmt->bind_param("iss", $user_id, $user_message, $bot_response);
        $stmt->execute();
    }
}

// Funkcija, kas meklē atbildi pēc atslēgvārda no datubāzes
function getBotResponse($mysqli, $message) {
    $stmt = $mysqli->prepare("SELECT response FROM chatbot_knowledge WHERE ? LIKE CONCAT('%', keyword, '%') LIMIT 1");
    $stmt->bind_param("s", $message);
    $stmt->execute();
    $stmt->bind_result($response);
    
    // Ja atrasta atbilde, to atgriež
    if ($stmt->fetch()) {
        return $response;
    } else {
          // Ja nav atrasta, atgriež noklusēto atbildi
        return "Piedod, es vēl nezinu atbildi uz šo jautājumu.";
    }
}

// Iegūst visus sarunas ierakstus no datubāzes konkrētajam lietotājam
$stmt = $mysqli->prepare("SELECT user_message, bot_response FROM chat_logs WHERE user_id = ? ORDER BY created_at ASC");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$messages = $result->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <title>Chat Bot</title>
      <!-- Pievieno CSS stilu failu -->
    <link rel="stylesheet" href="../assets/style.css">
</head>
<body>
    <div class="container">
    <h1>Saruna ar tērzēšanas robotu</h1>
<p>Šajā lapā tu vari saņemt atbildes un palīdzību dažādos jautājumos, vienkārši uzdodot jautājumu vai tērzējot ar tērzēšanas robotu!</p>

    <div id="chat-window">
        <div id="messages">
                <!-- Izvada sarunu no datubāzes -->
           <?php foreach ($messages as $msg): ?>
    <div class="chat-message user"><strong>Jūs:</strong> <?php echo htmlspecialchars($msg['user_message']); ?></div>
    <div class="chat-message bot"><strong>Bots:</strong> <?php echo htmlspecialchars($msg['bot_response']); ?></div>
<?php endforeach; ?>
        </div>

         <!-- Ievades forma lietotāja ziņojumam -->
        <form method="POST">
            <input type="text" name="user_message" placeholder="Ieraksti ziņojumu..." required />
            <button type="submit">Sūtīt</button>
        </form>
    </div>

      <!-- Poga, lai atgrieztos uz galveno lapu -->
   <button class="logout" onclick="window.location.href='main.php'">Atpakaļ uz galveno lapu</button>
 </div>
</body>
</html>
