<?php
session_start();
include('../includes/db.php');  // Savienojums ar datu bāzi

if (isset($_POST['meditation_id']) && isset($_SESSION['user_id'])) {
    $meditation_id = $_POST['meditation_id'];
    $user_id = $_SESSION['user_id'];

    // Pārbaudām, vai meditācija jau ir kolekcijā
    $stmt = $mysqli->prepare("SELECT * FROM favorite_meditations WHERE user_id = ? AND meditation_id = ?");
    $stmt->bind_param("ii", $user_id, $meditation_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // Ja meditācija jau ir kolekcijā, atgriežam ziņojumu
        echo "Šī meditācija jau ir pievienota kolekcijai!";
    } else {
        // Ja meditācija vēl nav kolekcijā, pievienojam to
        $stmt = $mysqli->prepare("INSERT INTO favorite_meditations (user_id, meditation_id) VALUES (?, ?)");
        $stmt->bind_param("ii", $user_id, $meditation_id);
        $stmt->execute();

        if ($stmt->affected_rows > 0) {
            echo "Meditācija pievienota kolekcijai!";
        } else {
            echo "Kļūda pievienojot meditāciju kolekcijai.";
        }
    }

    $stmt->close();
} else {
    echo "Nepareizi pieprasījumi vai lietotājs nav pieteicies.";
}

$mysqli->close();
?>
