// Funkcija, kas parāda meditāciju veidus
function showMeditationTypes() {
    // Paslēpjam citus sadalījumus
    document.getElementById("quotesSection").style.display = "none";//paslēpj citātu sadaļu
    document.getElementById("chatbotSection").style.display = "none";//paslēpj tērzēšanas bota sadaļu
    
    // Parāda meditāciju veidus
    document.getElementById("meditationsSection").style.display = "block";

    // Pārsūtam pieprasījumu uz serveri, lai saņemtu meditāciju veidus
    fetch('get_meditations.php')// Vaicājums uz serveri, lai iegūtu meditāciju datus
        .then(response => response.json())// Datus pārvērš JSON formātā
        .then(data => {
            let meditationList = document.getElementById("meditationList");// HTML elements meditāciju sarakstam
            meditationList.innerHTML = ""; // Notīram esošo sarakstu
            data.forEach(meditation => {// Iterē cauri iegūtajiem meditāciju datiem
                let div = document.createElement('div');// Izveido jaunu <div> elementu katrai meditācijai
                div.textContent = meditation.name;// Iestata meditācijas nosaukumu
                meditationList.appendChild(div);// Pievieno meditāciju sarakstam
            });
        })
        .catch(error => {
            // Apstrādā kļūdu gadījumā, ja neizdodas iegūt meditāciju datus
            console.error("Kļūda, iegūstot meditāciju:", error);
        });
}

// Funkcija, kas parāda motivējošus citātus
function showQuoteTypes() {
    // Paslēpjam citus sadalījumus
    document.getElementById("meditationsSection").style.display = "none";// Paslēpj meditāciju sadaļu
    document.getElementById("chatbotSection").style.display = "none";// Paslēpj tērzēšanas bota sadaļu
    
    // Parādām citātus
    document.getElementById("quotesSection").style.display = "block";

    // Pārsūtam pieprasījumu uz serveri, lai saņemtu citātus
    fetch('get_quotes.php')// Vaicājums uz serveri citātu iegūšanai
        .then(response => response.json())// Datus pārvērš JSON formātā
        .then(data => {
            let quotesList = document.getElementById("quotesList");// HTML elements citātu sarakstam
            quotesList.innerHTML = ""; // Notīram esošo sarakstu
            data.forEach(quote => {// Iterē cauri iegūtajiem citātiem
                let div = document.createElement('div');// Izveido jaunu <div> katram citātam
                div.textContent = quote.text;// Iestata citāta tekstu
                quotesList.appendChild(div); // Pievieno citātu sarakstam
            });
        })
        .catch(error => {
             // Pievieno citātu sarakstam
            console.error("Kļūda, iegūstot citātus:", error);
        });
}

// Funkcija, kas parāda sarunu ar botu
function showChatbot() {
    // Paslēpjam citus sadalījumus
    document.getElementById("meditationsSection").style.display = "none";
    document.getElementById("quotesSection").style.display = "none";
    
    // Parādām sarunu ar botu
    document.getElementById("chatbotSection").style.display = "block";
}
