<?php
require 'datu_bazes_pieslegsanas.php';
session_start();

// Pārbaudām, vai lietotājs ir ielogojies
if (isset($_SESSION['lietotajvards'])) {
    $lietotajvards = $_SESSION['lietotajvards'];
} else {
    session_destroy();
    header('Location: pieslegties.php');
    exit;
}

// Ziņas izvadīšana
$zina = '';
if (isset($_SESSION['ziņa']) && isset($_SESSION['status'])) {
    $zina = $_SESSION['ziņa'];
    $alertType = $_SESSION['status'] === 'success' ? 'success' : 'danger';
    echo "<script>alert('$zina');</script>";
    unset($_SESSION['ziņa'], $_SESSION['status']);
}

// Izgūst dziesmas no datu bāzes (nejaušā secībā) un pievieno limitu
$query = "SELECT nosaukums, autors, dziesma, id FROM muzika ORDER BY RAND() LIMIT 10"; // Limita pievienošana
$stmt = $conn->prepare($query);
$stmt->execute();
$result = $stmt->get_result();

// Pievienot dziesmu favorītiem
if (isset($_POST['pievienot_favoritiem'])) {
    $dziesma_id = $_POST['dziesma_id'];
    $lietotajvards = $_SESSION['lietotajvards'];

    $insert_fav = "INSERT INTO favoriti (lietotajvards, dziesma_id) VALUES (?, ?)";
    $stmt = $conn->prepare($insert_fav);
    $stmt->bind_param("si", $lietotajvards, $dziesma_id);
    if ($stmt->execute()) {
        $_SESSION['ziņa'] = "Dziesma pievienota favorītiem!";
        $_SESSION['status'] = 'success';
    } else {
        $_SESSION['ziņa'] = "Kļūda pievienojot dziesmu favorītiem.";
        $_SESSION['status'] = 'danger';
    }
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit;
}

// // Pievienot dziesmu sarakstam
// if (isset($_POST['add_to_playlist'])) {
//     $dziesma_id = $_POST['dziesma_id'];
//     $playlist_id = $_POST['playlist_id']; // Atceramies, ka sarakstam jābūt izvēlētam
//     $lietotajvards = $_SESSION['lietotajvards'];

//     $insert_playlist = "INSERT INTO saraksti (playlist_id, dziesma_id) VALUES (?, ?)";
//     $stmt = $conn->prepare($insert_playlist);
//     $stmt->bind_param("ii", $playlist_id, $dziesma_id);
//     if ($stmt->execute()) {
//         $_SESSION['ziņa'] = "Dziesma pievienota sarakstam!";
//         $_SESSION['status'] = 'success';
//     } else {
//         $_SESSION['ziņa'] = "Kļūda pievienojot dziesmu sarakstam.";
//         $_SESSION['status'] = 'danger';
//     }
//     header('Location: ' . $_SERVER['PHP_SELF']);
//     exit;
// }

if (isset($_GET['search'])) {
    $search_query = $_GET['search'];
    $search_query = htmlspecialchars($search_query);

    // SQL vaicājums meklēšanai pēc nosaukuma vai autora
    $query = "SELECT nosaukums, autors, dziesma, id FROM muzika WHERE nosaukums LIKE ? OR autors LIKE ?";
    $stmt = $conn->prepare($query);
    $search_term = '%' . $search_query . '%';
    $stmt->bind_param("ss", $search_term, $search_term);
    $stmt->execute();
    $result = $stmt->get_result();

    $dziesmas = [];
    while ($row = $result->fetch_assoc()) {
        $dziesmas[] = [
            'nosaukums' => $row['nosaukums'],
            'autors' => $row['autors'],
            'dziesma' => base64_encode($row['dziesma']), // Konvertē BLOB uz base64
        ];
    }

    // Atgriež rezultātus kā JSON
    echo json_encode($dziesmas);
}
?>

<!DOCTYPE html>
<html lang="lv">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mūzikas aplikācija</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
</head>

<body>

    <!-- Navigācijas josla -->
    <nav class="navbar navbar-light bg-light px-3 fixed-top">
        <div class="container-fluid">
            <div class="d-flex align-items-center">
                <!-- Pogas, lai atvērtu sāna izvēlni -->
                <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasSidebar">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <!-- Meklēšanas forma -->
                <form class="d-flex ms-3">
                    <button class="btn btn-outline-secondary" type="submit">
                        <i class="bi bi-search"></i> <!-- Meklēšanas ikona -->
                    </button>
                    <input class="form-control me-2" type="search" placeholder="Meklēt" aria-label="Meklēt dziesmas">
                </form>
            </div>
            <div class="d-flex align-items-center">
                <!-- Parāda lietotājvārdu -->
                <?php echo htmlspecialchars($lietotajvards); ?>
                <!-- Ikona, lai pārietu uz sākumlapu -->
                <a href="sakums.php" class="ml-1"><img src="bildes/maja.png" alt="Sākumlapa" width="24"></a>
            </div>
        </div>
    </nav>

    <!-- Sāna izvēlne -->
    <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasSidebar" aria-labelledby="offcanvasSidebarLabel">
        <div class="offcanvas-header">
            <h5 class="offcanvas-title" id="offcanvasSidebarLabel">Izvēlne</h5>
            <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Aizvērt"></button>
        </div>
        <div class="offcanvas-body">
            <nav class="nav flex-column">
                <a class="nav-link" href="favoriti.php">Favorīti</a>
                <a class="nav-link" href="saraksti.php">Atskaņošanas saraksti</a>
                <a class="nav-link" href="manas_dziesmas.php">Manas dziesmas</a>
                <a class="nav-link" href="jauns_saraksts.php">Jauns atskaņošanas saraksts</a>
                <a class="nav-link" href="jauna_dziesma.php">Pievienot dziesmu</a>
                <a class="nav-link" href="iestatijumi.php">Iestatījumi</a>
                <a class="nav-link" href="izlogoties.php">Izlogoties</a>
            </nav>
        </div>
    </div>

    <!-- Galvenais saturs -->
    <div class="container mt-6" style="margin-top: 100px;">
        <h2 class="mt-4">Dziesmas</h2>
        <?php
        if ($result->num_rows > 0) {
            // Parāda katru dziesmu
            while ($row = $result->fetch_assoc()) {
                $nosaukums = htmlspecialchars($row['nosaukums']);
                $autors = htmlspecialchars($row['autors']);
                $dziesma = $row['dziesma'];
                $dziesma_id = $row['id'];
                $audioUrl = 'data:audio/mp3;base64,' . base64_encode($dziesma); // Konvertē BLOB uz base64
                ?>
                <div class="card mb-4">
                    <div class="card-body">
                        <h5 class="card-title"><?php echo $nosaukums; ?></h5>
                        <h6 class="card-subtitle mb-2 text-muted"><?php echo $autors; ?></h6>
                        <div class="d-flex justify-content-between align-items-center">
                            <audio controls style="flex-grow: 1;">
                                <source src="<?php echo $audioUrl; ?>" type="audio/mp3">
                                Your browser does not support the audio element.
                            </audio>
                            <div class="btn-group ms-3">
                                <form method="POST">
                                    <input type="hidden" name="dziesma_id" value="<?php echo $dziesma_id; ?>">
                                    <button type="submit" name="pievienot_favoritiem" class="btn btn-primary">Pievienot favorītiem</button>
                                </form>
                                <form method="POST" class="mt-2 mt-sm-0">
                                    <input type="hidden" name="dziesma_id" value="<?php echo $dziesma_id; ?>">
                                    <input type="hidden" name="playlist_id" value="1"> <!-- Piemēram, saraksta ID -->
                                    <button type="submit" name="add_to_playlist" class="btn btn-success">Pievienot sarakstam</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
            }
        } else {
            echo '<p class="text-center">Nav pievienotu dziesmu.</p>';
        }
        ?>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>
