<?php
require 'datu_bazes_pieslegsanas.php'; // Pievienojam datubāzes pieslēgumu
session_start(); // Startē sesiju

$zina = ''; // Mainīgais ziņojumiem

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $lietotajvards = trim($_POST['lietotajvards']);
    $parole = trim($_POST['parole']);

    if (empty($lietotajvards) || empty($parole)) {
        $_SESSION['zina'] = 'Visi lauki ir obligāti!'; // Ja kāds lauks ir tukšs, ziņojums kļūdas gadījumā
        $_SESSION['status'] = 'error';
    } else {
        try {
            // Pārbaudām, vai lietotājvārds jau eksistē datubāzē
            $stmt = $conn->prepare("SELECT COUNT(*) FROM lietotaji WHERE lietotajvards = ?");
            $stmt->bind_param('s', $lietotajvards);
            $stmt->execute();
            $stmt->bind_result($lietotajsEksiste);
            $stmt->fetch();
            $stmt->close();

            if ($lietotajsEksiste > 0) {
                // Ja lietotājvārds jau eksistē, parādām kļūdas ziņojumu
                $_SESSION['zina'] = 'Šāds lietotājvārds jau eksistē!';
                $_SESSION['status'] = 'error';
            } else {
                // Ja lietotājvārds ir unikāls, reģistrējam jaunu lietotāju
                $shifretaParole = password_hash($parole, PASSWORD_DEFAULT); // Paroles šifrēšana
                $stmt = $conn->prepare("INSERT INTO lietotaji (lietotajvards, parole) VALUES (?, ?)");
                $stmt->bind_param('ss', $lietotajvards, $shifretaParole);
                $stmt->execute();
                $stmt->close();

                // Iestatām sesijas mainīgos un pāradresējam uz sākumlapu
                $_SESSION['lietotajvards'] = $lietotajvards;
                $_SESSION['zina'] = 'Reģistrācija veiksmīga!';
                $_SESSION['status'] = 'success';

                header("Location: sakums.php"); // Pāradresācija uz sākumlapu
                exit();
            }
        } catch (Exception $e) {
            // Ja ir kļūda, parādām kļūdas ziņojumu
            $_SESSION['zina'] = 'Kļūda: ' . $e->getMessage();
            $_SESSION['status'] = 'error';
        }
    }
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reģistrēties</title>
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
<!-- Galvenais konteneris ar centēšanu -->
<div class="container d-flex justify-content-center align-items-center vh-100">
    <div class="border p-4" style="width: 300px;">
        <!-- Formas nosaukums -->
        <h2 class="text-center">Reģistrācija</h2>
        <form action="" method="post">
            <!-- Lietotājvārda ievades lauks -->
            <div class="form-group">
                <label for="lietotajvards">Lietotājvārds</label>
                <input type="text" class="form-control" id="lietotajvards" name="lietotajvards" required>
            </div>
            <!-- Paroles ievades lauks -->
            <div class="form-group">
                <label for="parole">Parole</label>
                <input type="password" class="form-control" id="parole" name="parole" required>
            </div>
            <!-- Reģistrēšanās poga -->
            <button type="submit" class="btn btn-outline-dark btn-block">Reģistrēties</button>
        </form>
        <!-- Parādām ziņojumus (kļūda vai veiksmīgi) -->
        <?= $zina; ?>
        <div class="text-left pt-3">
            <!-- Poga, lai pārietu uz pieslēgšanās lapu -->
            <p><a href="pieslegties.php" class="btn btn-outline-dark">Pieslēgties</a></p>
        </div>
    </div>
</div>

<!-- Bootstrap JS un nepieciešamās atkarības -->
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
