<?php
require 'datu_bazes_pieslegsanas.php';
session_start();

$ziņa = ''; // Ziņojumu mainīgais

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $lietotajvards = htmlspecialchars(trim($_POST['lietotajvards']));
    $parole = trim($_POST['parole']);

    if (empty($lietotajvards) || empty($parole)) {
        $ziņa = '<p class="text-danger text-center">Visi lauki ir obligāti!</p>';
    } else {
        try {
            // Vaicājums datubāzei
            $stmt = $conn->prepare("SELECT parole FROM lietotaji WHERE lietotajvards = ?");
            $stmt->bind_param('s', $lietotajvards);
            $stmt->execute();
            $stmt->bind_result($saglabataParole);
            
            if ($stmt->fetch()) {
                // Parole atrasta, salīdzinām
                if (password_verify($parole, $saglabataParole)) {
                    $_SESSION['lietotajvards'] = $lietotajvards;
                    header("Location: sakums.php");
                    exit();
                } else {
                    $ziņa = '<p class="text-danger text-center">Nepareizs lietotājvārds vai parole!</p>';
                }
            } else {
                $ziņa = '<p class="text-danger text-center">Nepareizs lietotājvārds vai parole!</p>';
            }
            $stmt->close();
        } catch (Exception $e) {
            $ziņa = '<p class="text-danger text-center">Kļūda: ' . $e->getMessage() . '</p>';
        }
    }
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pieslēgties</title>
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
<!-- Galvenais konteneris, kas satur formas un ziņojumus -->
<div class="container d-flex justify-content-center align-items-center vh-100">
    <div class="border p-4" style="width: 300px;">
        <!-- Formas nosaukums -->
        <h2 class="text-center">Pieslēgties</h2>
        <form action="" method="post">
            <!-- Lietotājvārda ievades lauks -->
            <div class="form-group">
                <label for="lietotajvards">Lietotājvārds</label>
                <input type="text" class="form-control" id="lietotajvards" name="lietotajvards" required>
            </div>
            <!-- Paroles ievades lauks -->
            <div class="form-group">
                <label for="parole">Parole</label>
                <input type="password" class="form-control" id="parole" name="parole" required>
            </div>
            <!-- Pieslēgšanās poga -->
            <button type="submit" class="btn btn-outline-dark btn-block">Pieslēgties</button>
        </form>
        <!-- Ja ir ziņojums, tad tas tiks parādīts -->
        <?php if (!empty($ziņa)) echo $ziņa; ?>
        <!-- Poga saitei uz reģistrācijas lapu -->
        <div class="text-left pt-3">
            <p><a href="registreties.php" class="btn btn-outline-dark">Reģistrēties</a></p>
        </div>
    </div>
</div>

<!-- Bootstrap JS, kas nepieciešams, lai strādātu dažām funkcijām -->
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
