<?php
require 'datu_bazes_pieslegsanas.php';
session_start();

if (isset($_SESSION['lietotajvards'])) {
    $lietotajvards = $_SESSION['lietotajvards'];
} else {
    session_destroy();
    header('Location: pieslegties.php');
    exit;
}

// Izgūst dziesmas, kuru autors ir ielogotais lietotājs
$query = "SELECT nosaukums, autors, dziesma, id FROM muzika WHERE autors = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param('s', $lietotajvards);
$stmt->execute();
$result = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="lv">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Jauns atskaņošanas saraksts</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body>

    <!-- Navigācijas josla -->
    <nav class="navbar navbar-light bg-light px-3 fixed-top">
        <div class="container-fluid">
            <div class="d-flex align-items-center">
                <!-- Pogas, lai atvērtu sāna izvēlni -->
                <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasSidebar">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <!-- Meklēšanas forma -->
                <form class="d-flex ms-3">
                    <button class="btn btn-outline-secondary" type="submit">
                        <i class="bi bi-search"></i> <!-- Meklēšanas ikona -->
                    </button>
                    <input class="form-control me-2" type="search" placeholder="Meklēt" aria-label="Meklēt dziesmas">
                </form>
            </div>
            <div class="d-flex align-items-center">
                <!-- Parāda lietotājvārdu -->
                <?php echo htmlspecialchars($lietotajvards); ?>
                <!-- Ikona, lai pārietu uz sākumlapu -->
                <a href="sakums.php" class="ml-1"><img src="bildes/maja.png" alt="Sākumlapa" width="24"></a>
            </div>
        </div>
    </nav>

    <!-- Sāna izvēlne -->
    <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasSidebar" aria-labelledby="offcanvasSidebarLabel">
        <div class="offcanvas-header">
            <h5 class="offcanvas-title" id="offcanvasSidebarLabel">Izvēlne</h5>
            <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Aizvērt"></button>
        </div>
        <div class="offcanvas-body">
            <nav class="nav flex-column">
                <a class="nav-link" href="favoriti.php">Favorīti</a>
                <a class="nav-link" href="saraksti.php">Atskaņošanas saraksti</a>
                <a class="nav-link" href="manas_dziesmas.php">Manas dziesmas</a>
                <a class="nav-link active" href="jauns_saraksts.php">Jauns atskaņošanas saraksts</a>
                <a class="nav-link" href="jauna_dziesma.php">Pievienot dziesmu</a>
                <a class="nav-link" href="iestatijumi.php">Iestatījumi</a>
                <a class="nav-link" href="izlogoties.php">Izlogoties</a>
            </nav>
        </div>
    </div>

    <!-- Dziesmu saraksts -->
    <div class="container mt-6" style="margin-top: 100px;">
        <h2 class="mt-4">Manas dziesmas</h2>
        <?php
        if ($result->num_rows > 0) {
            // Parāda katru dziesmu
            while ($row = $result->fetch_assoc()) {
                $nosaukums = htmlspecialchars($row['nosaukums']);
                $autors = htmlspecialchars($row['autors']);
                $dziesma = $row['dziesma'];
                $dziesmas_id = $row['id'];
                $audioUrl = 'data:audio/mp3;base64,' . base64_encode($dziesma); // Konvertē BLOB uz base64
                ?>
                <div class="card mb-4">
                    <div class="card-body">
                        <h5 class="card-title"><?php echo $nosaukums; ?></h5>
                        <h6 class="card-subtitle mb-2 text-muted"><?php echo $autors; ?></h6>
                        <div class="d-flex justify-content-between align-items-center">
                            <!-- Audio atskaņotājs -->
                            <audio controls style="flex-grow: 1;">
                                <source src="<?php echo $audioUrl; ?>" type="audio/mp3">
                                Your browser does not support the audio element.
                            </audio>
                            <!-- Poga pievienot favorītiem un sarakstam -->
                            <div class="btn-group ms-3">
                                <form method="POST" class="d-inline">
                                    <input type="hidden" name="dziesmas_id" value="<?php echo $dziesmas_id; ?>">
                                    <button type="submit" name="pievienot_favoritiem" class="btn btn-primary">Pievienot favorītiem</button>
                                </form>
                                <form method="POST" class="d-inline">
                                    <input type="hidden" name="dziesmas_id" value="<?php echo $dziesmas_id; ?>">
                                    <input type="hidden" name="playlist_id" value="1"> <!-- Piemērs saraksta ID -->
                                    <button type="submit" name="add_to_playlist" class="btn btn-success">Pievienot sarakstam</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
            }
        } else {
            echo '<p class="text-center">Nav pievienotu dziesmu.</p>';
        }
        ?>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>
