<?php
require 'datu_bazes_pieslegsanas.php';
session_start();

// Pārbauda, vai lietotājs ir pieslēdzies
if (isset($_SESSION['lietotajvards'])) {
    $lietotajvards = $_SESSION['lietotajvards'];
} else {
    session_destroy();
    header('Location: pieslegties.php');
    exit;
}

// Iegūst lietotāja ID no datubāzes, izmantojot lietotājvārdu
$query = "SELECT id FROM lietotaji WHERE lietotajvards = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param('s', $lietotajvards);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $lietotaja_id = $row['id']; // Lietotāja ID
} else {
    session_destroy();
    header('Location: pieslegties.php');
    exit;
}

require 'datu_bazes_pieslegsanas.php';
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Saņem iesūtītos datus
    $nosaukums = $_POST['nosaukums'];
    $apraksts = $_POST['apraksts'];
    $lietotaja_id = $_POST['lietotaja_id']; // Lietotāja ID no formas

    // Validācija
    if (empty($nosaukums) || empty($apraksts) || empty($lietotaja_id)) {
        header('Location: jauns_saraksts.php?error=1');
        exit;
    }

    // Saglabā jauno sarakstu datubāzē
    $query = "INSERT INTO saraksti (lietotaja_id, nosaukums, apraksts) VALUES (?, ?, ?)";
    $stmt = $conn->prepare($query);
    $stmt->bind_param('iss', $lietotaja_id, $nosaukums, $apraksts);

    if ($stmt->execute()) {
        header('Location: saraksti.php?success=1');
    } else {
        header('Location: jauns_saraksts.php?error=1');
    }
    exit;
}

?>

<!DOCTYPE html>
<html lang="lv">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Jauns atskaņošanas saraksts</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body>

    <!-- Navigācijas josla -->
    <nav class="navbar navbar-light bg-light px-3 fixed-top">
        <div class="container-fluid">
            <div class="d-flex align-items-center">
                <!-- Pogas, lai atvērtu sāna izvēlni -->
                <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasSidebar">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <!-- Meklēšanas forma -->
                <form class="d-flex ms-3">
                    <button class="btn btn-outline-secondary" type="submit">
                        <i class="bi bi-search"></i> <!-- Meklēšanas ikona -->
                    </button>
                    <input class="form-control me-2" type="search" placeholder="Meklēt" aria-label="Meklēt dziesmas">
                </form>
            </div>
            <div class="d-flex align-items-center">
                <!-- Parāda lietotājvārdu -->
                <?php echo htmlspecialchars($lietotajvards); ?>
                <!-- Ikona, lai pārietu uz sākumlapu -->
                <a href="sakums.php" class="ml-1"><img src="bildes/maja.png" alt="Sākumlapa" width="24"></a>
            </div>
        </div>
    </nav>

    <!-- Sāna izvēlne -->
    <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasSidebar" aria-labelledby="offcanvasSidebarLabel">
        <div class="offcanvas-header">
            <h5 class="offcanvas-title" id="offcanvasSidebarLabel">Izvēlne</h5>
            <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Aizvērt"></button>
        </div>
        <div class="offcanvas-body">
            <nav class="nav flex-column">
                <a class="nav-link" href="favoriti.php">Favorīti</a>
                <a class="nav-link" href="saraksti.php">Atskaņošanas saraksti</a>
                <a class="nav-link" href="manas_dziesmas.php">Manas dziesmas</a>
                <a class="nav-link" href="jauns_saraksts.php">Jauns atskaņošanas saraksts</a>
                <a class="nav-link" href="jauna_dziesma.php">Pievienot dziesmu</a>
                <a class="nav-link" href="iestatijumi.php">Iestatījumi</a>
                <a class="nav-link" href="izlogoties.php">Izlogoties</a>
            </nav>
        </div>
    </div>

    <!-- Jauna atskaņošanas saraksta pievienošanas forma -->
    <div class="container d-flex justify-content-center align-items-center" style="height: 100vh;">
        <div>
            <h2 class="text-center">Jauns atskaņošanas saraksts</h2>
            <form action="" method="post">
                <div class="mb-3">
                    <label for="nosaukums" class="form-label">Atskaņošanas saraksta nosaukums:</label>
                    <input type="text" class="form-control" id="nosaukums" name="nosaukums" required>
                </div>
                <div class="mb-3">
                    <label for="apraksts" class="form-label">Apraksts:</label>
                    <textarea class="form-control" id="apraksts" name="apraksts" rows="3" required></textarea>
                </div>
                <!-- Nosūta lietotāja ID -->
                <input type="hidden" name="lietotaja_id" value="<?php echo $lietotaja_id; ?>">
                <button type="submit" class="btn btn-primary w-100">Izveidot</button>
            </form>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
