<?php
// Pievieno datubāzes pieslēguma skriptu
require 'datu_bazes_pieslegsanas.php';

// Sāk sesiju
session_start();

// Pārbauda, vai lietotājs ir ielogojies
if (isset($_SESSION['lietotajvards'])) {
    $lietotajvards = $_SESSION['lietotajvards']; // Iegūst lietotājvārdu no sesijas
} else {
    session_destroy(); // Ja lietotājs nav ielogojies, sesija tiek iznīcināta
    header('Location: pieslegties.php'); // Novirza uz pieslēgšanās lapu
    exit;
}

// Sākotnēji ziņa ir tukša
$zina = '';

// Pārbauda, vai veidlapa ir iesniegta
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $dziesmasNosaukums = trim($_POST['nosaukums']); // Saņem un apgriež dziesmas nosaukumu
    $dziesmasFails = $_FILES['dziesma']; // Saņem augšupielādēto failu

    // Pārbauda, vai visi nepieciešamie lauki ir aizpildīti
    if (empty($dziesmasNosaukums) || empty($dziesmasFails['name'])) {
        $zina = '<p class="text-danger text-center">Lūdzu, aizpildiet visus laukus!</p>';
    } else {
        // Definē atļautos failu tipus
        $atļautieTipi = ['audio/mpeg', 'audio/mp3', 'audio/wav'];
        if (!in_array($dziesmasFails['type'], $atļautieTipi)) {
            $zina = '<p class="text-danger text-center">Fails ir neatbilstošā formātā!</p>';
        } else {
            try {
                // Iegūst faila saturu, lai to saglabātu BLOB laukā
                $dziesmasSaturs = file_get_contents($dziesmasFails['tmp_name']);

                // Izveido SQL vaicājumu dziesmas pievienošanai datubāzē
                $stmt = $conn->prepare("INSERT INTO muzika (nosaukums, autors, dziesma) VALUES (?, ?, ?)");
                $stmt->bind_param('ssb', $dziesmasNosaukums, $lietotajvards, $dziesmasSaturs);

                // Saista faila saturu kā BLOB datus
                $null = NULL;
                $stmt->send_long_data(2, $dziesmasSaturs);

                // Izpilda vaicājumu un pārbauda, vai tas bija veiksmīgs
                if ($stmt->execute()) {
                    $zina = '<p class="text-success text-center">Dziesma veiksmīgi pievienota!</p>';
                } else {
                    $zina = '<p class="text-danger text-center">Kļūda pievienojot dziesmu!</p>';
                }
                $stmt->close();
            } catch (Exception $e) {
                // Gadījumā, ja notiek kļūda, tiek rādīta kļūdas ziņa
                $zina = '<p class="text-danger text-center">Kļūda: ' . $e->getMessage() . '</p>';
            }
        }
    }
}
?>


<!DOCTYPE html>
<html lang="lv">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Jauna dziesma</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body>

    <!-- Navigācijas josla -->
    <nav class="navbar navbar-light bg-light px-3 fixed-top">
        <div class="container-fluid">
            <div class="d-flex align-items-center">
                <!-- Pogas, lai atvērtu sāna izvēlni -->
                <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasSidebar">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <!-- Meklēšanas forma -->
                <form class="d-flex ms-3">
                    <button class="btn btn-outline-secondary" type="submit">
                        <i class="bi bi-search"></i> <!-- Meklēšanas ikona -->
                    </button>
                    <input class="form-control me-2" type="search" placeholder="Meklēt" aria-label="Meklēt dziesmas">
                </form>
            </div>
            <div class="d-flex align-items-center">
                <!-- Parāda lietotājvārdu -->
                <?php echo htmlspecialchars($lietotajvards); ?>
                <!-- Ikona, lai pārietu uz sākumlapu -->
                <a href="sakums.php" class="ml-1"><img src="bildes/maja.png" alt="Sākumlapa" width="24"></a>
            </div>
        </div>
    </nav>
    <!-- Sāna izvēlne -->
    <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasSidebar" aria-labelledby="offcanvasSidebarLabel">
        <div class="offcanvas-header">
            <h5 class="offcanvas-title" id="offcanvasSidebarLabel">Izvēlne</h5>
            <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Aizvērt"></button>
        </div>
        <div class="offcanvas-body">
            <nav class="nav flex-column">
                <a class="nav-link" href="favoriti.php">Favorīti</a>
                <a class="nav-link" href="saraksti.php">Atskaņošanas saraksti</a>
                <a class="nav-link" href="manas_dziesmas.php">Manas dziesmas</a>
                <a class="nav-link active" href="jauns_saraksts.php">Jauns atskaņošanas saraksts</a>
                <a class="nav-link" href="jauna_dziesma.php">Pievienot dziesmu</a>
                <a class="nav-link" href="iestatijumi.php">Iestatījumi</a>
                <a class="nav-link" href="izlogoties.php">Izlogoties</a>
            </nav>
        </div>
    </div>

    <!-- Jaunas dziesmas pievienošanas forma -->
    <div class="container d-flex justify-content-center align-items-center" style="height: 100vh;">
        <div>
            <h2 class="text-center">Jauna dziesma</h2>
            <?= $zina; // Parāda ziņu, ja tāda ir ?>
            <form action="jauna_dziesma.php" method="post" enctype="multipart/form-data">
                <div class="mb-3">
                    <label for="nosaukums" class="form-label">Nosaukums:</label>
                    <input type="text" class="form-control" id="nosaukums" name="nosaukums" required>
                </div>
                <div class="mb-3">
                    <label for="dziesma" class="form-label">Fails:</label>
                    <input type="file" class="form-control" id="dziesma" name="dziesma" accept="audio/*" required>
                </div>
                <button type="submit" class="btn btn-primary w-100">Pievienot</button>
            </form>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
