<?php
require 'datu_bazes_pieslegsanas.php';
session_start();

if (isset($_SESSION['lietotajvards'])) {
    $lietotajvards = $_SESSION['lietotajvards'];
} else {
    session_destroy();
    header('Location: pieslegties.php');
    exit;
}
?>

<!DOCTYPE html>
<html lang="lv">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Iestatījumi</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body>

    <!-- Navigācijas josla -->
    <nav class="navbar navbar-light bg-light px-3 fixed-top">
    <div class="container-fluid">
        <div class="d-flex align-items-center">
            <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasSidebar">
                <span class="navbar-toggler-icon"></span>
            </button>
            <form class="d-flex ms-3">
                <button class="btn btn-outline-secondary" type="submit">
                    <i class="bi bi-search"></i> <!-- Palielinājuma stikla ikona -->
                </button>
                <input class="form-control me-2" type="search" placeholder="Meklēt" aria-label="Meklēt dziesmas">
            </form>
        </div>
        <div class="d-flex align-items-center">
            <?php echo htmlspecialchars($lietotajvards); ?>
            <a href="sakums.php" class="ml-1"><img src="bildes/maja.png" alt="Sākumlapa" width="24"></a>
            <div class="rounded-circle bg-light text-center" style="width: 40px; height: 40px; line-height: 40px;">
            </div>
        </div>
    </div>
</nav>

    <!-- Sāna izvēlne -->
    <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasSidebar" aria-labelledby="offcanvasSidebarLabel">
        <div class="offcanvas-header">
            <h5 class="offcanvas-title" id="offcanvasSidebarLabel">Izvēlne</h5>
            <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Aizvērt"></button>
        </div>
        <div class="offcanvas-body">
            <!-- Pogas sāna izvēlnē priekš Favorītu, Atskaņošanas sarakstu, dziesmas vai saraksta pievienošanas un iestatījumu logiem -->
            <nav class="nav flex-column">
                <a class="nav-link" href="favoriti.php">Favorīti</a>
                <a class="nav-link" href="saraksti.php">Atskaņošanas saraksti</a>
                <a class="nav-link" href="manas_dziesmas.php">Manas dziesmas</a>
                <a class="nav-link active" href="jauns_saraksts.php">Jauns atskaņošanas saraksts</a>
                <a class="nav-link" href="jauna_dziesma.php">Pievienot dziesmu</a>
                <a class="nav-link" href="iestatijumi.php">Iestatījumi</a>
                <a class="nav-link" href="izlogoties.php">Izlogoties</a>
            </nav>
        </div>
    </div>

    <!-- Iestatījumu lapa -->
    <div class="container mt-6" style="margin-top: 100px;">
        <div class="row justify-content-center">
            <div class="col-12 col-md-6 text-center">
                <!-- Profila attēla maiņa -->
                <form action="upload_profile_picture.php" method="post" enctype="multipart/form-data">
                    <div class="mb-3">
                        <!-- Pašreizējā profila bilde -->
                        <img src="current-profile-picture.png" alt="Profila attēls" class="rounded-circle mb-3" width="100" height="100">
                    </div>
                    <div class="mb-3">
                        <label for="profilePicture" class="form-label">Pievienot bildi</label>
                        <input class="form-control" type="file" id="profilePicture" name="profilePicture" aria-label="Pievienot bildi">
                    </div>
                    <button type="submit" class="btn btn-outline-dark">Mainīt</button>
                </form>

                <!-- Iestatījumu forma -->
                <h2 class="mt-4">Iestatījumi</h2>
                <form action="settings_update.php" method="post">
                    <div class="mb-3">
                        <label for="nickname" class="form-label">Lietotājvārds</label>
                        <input type="text" class="form-control" id="nickname" name="nickname" placeholder="Lietotājvārds">
                    </div>
                    <div class="mb-3">
                        <label for="password" class="form-label">Parole</label>
                        <input type="password" class="form-control" id="password" name="password" placeholder="Parole">
                    </div>
                    <button type="submit" class="btn btn-primary">Saglabāt</button>
                </form>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
