<?php
// Iekļauj datubāzes savienojuma skriptu
require 'datu_bazes_pieslegsanas.php';

// Sāk sesiju, lai piekļūtu lietotāja sesijas datiem
session_start();

// Pārbauda, vai lietotājs ir ielogojies
if (isset($_SESSION['lietotajvards'])) {
    // Ja lietotājs ir ielogojies, ielādē lietotājvārdu no sesijas
    $lietotajvards = $_SESSION['lietotajvards'];
} else {
    // Ja lietotājs nav ielogojies, iznīcina sesiju un novirza uz pieslēgšanās lapu
    session_destroy();
    header('Location: pieslegties.php');
    exit;
}

// SQL vaicājums, lai iegūtu lietotāja favorītus no datubāzes
$query = "SELECT m.nosaukums, m.autors, m.dziesma, m.id 
          FROM favoriti f 
          JOIN muzika m ON f.dziesma_id = m.id 
          WHERE f.lietotajvards = ?";

// Sagatavo SQL vaicājumu
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $lietotajvards);
$stmt->execute();
$result = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="lv">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Favorīti</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body>

    <!-- Navigācijas josla -->
    <nav class="navbar navbar-light bg-light px-3 fixed-top">
        <div class="container-fluid">
            <div class="d-flex align-items-center">
                <!-- Pogas, lai atvērtu sāna izvēlni -->
                <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasSidebar">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <!-- Meklēšanas forma -->
                <form class="d-flex ms-3">
                    <button class="btn btn-outline-secondary" type="submit">
                        <i class="bi bi-search"></i> <!-- Meklēšanas ikona -->
                    </button>
                    <input class="form-control me-2" type="search" placeholder="Meklēt" aria-label="Meklēt dziesmas">
                </form>
            </div>
            <div class="d-flex align-items-center">
                <!-- Parāda lietotājvārdu -->
                <?php echo htmlspecialchars($lietotajvards); ?>
                <!-- Ikona, lai pārietu uz sākumlapu -->
                <a href="sakums.php" class="ml-1"><img src="bildes/maja.png" alt="Sākumlapa" width="24"></a>
            </div>
        </div>
    </nav>

    <!-- Sāna izvēlne -->
    <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasSidebar" aria-labelledby="offcanvasSidebarLabel">
        <div class="offcanvas-header">
            <h5 class="offcanvas-title" id="offcanvasSidebarLabel">Izvēlne</h5>
            <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Aizvērt"></button>
        </div>
        <div class="offcanvas-body">
            <!-- Sāna izvēlnes navigācija -->
            <nav class="nav flex-column">
                <a class="nav-link active" href="favoriti.php">Favorīti</a>
                <a class="nav-link" href="saraksti.php">Atskaņošanas saraksti</a>
                <a class="nav-link" href="manas_dziesmas.php">Manas dziesmas</a>
                <a class="nav-link" href="jauns_saraksts.php">Jauns atskaņošanas saraksts</a>
                <a class="nav-link" href="jauna_dziesma.php">Pievienot dziesmu</a>
                <a class="nav-link" href="iestatijumi.php">Iestatījumi</a>
                <a class="nav-link" href="izlogoties.php">Izlogoties</a>
            </nav>
        </div>
    </div>

    <!-- Galvenais saturs -->
    <div class="container mt-6" style="margin-top: 100px;">
        <h2 class="mt-4">Favorīti</h2>
        <div>
            <?php
            // Pārbauda, vai rezultāti nav tukši
            if ($result->num_rows > 0) {
                // Parāda katru dziesmu no favorītiem
                while ($row = $result->fetch_assoc()) {
                    // Sanitizē un sagatavo datus no datubāzes
                    $nosaukums = htmlspecialchars($row['nosaukums']);
                    $autors = htmlspecialchars($row['autors']);
                    $dziesma = $row['dziesma'];
                    $dziesma_id = $row['id'];
                    $audioUrl = 'data:audio/mp3;base64,' . base64_encode($dziesma); // Konvertē audio uz Base64
                    ?>
                    <!-- Karte, kas attēlo dziesmu -->
                    <div class="card mb-4">
                        <div class="card-body">
                            <h5 class="card-title"><?php echo $nosaukums; ?></h5>
                            <h6 class="card-subtitle mb-2 text-muted"><?php echo $autors; ?></h6>
                            <div class="d-flex justify-content-between align-items-center">
                                <!-- Audio atskaņotājs -->
                                <audio controls style="flex-grow: 1;">
                                    <source src="<?php echo $audioUrl; ?>" type="audio/mp3">
                                    Your browser does not support the audio element.
                                </audio>
                                <!-- Poga, lai pievienotu dziesmas favorītiem vai sarakstiem -->
                                <div class="btn-group ms-3">
                                    <form method="POST">
                                        <input type="hidden" name="dziesma_id" value="<?php echo $dziesma_id; ?>">
                                        <button type="submit" name="pievienot_favoritiem" class="btn btn-primary">Pievienot favorītiem</button>
                                    </form>
                                    <form method="POST" class="mt-2 mt-sm-0">
                                        <input type="hidden" name="dziesma_id" value="<?php echo $dziesma_id; ?>">
                                        <input type="hidden" name="playlist_id" value="1"> <!-- Piemēram, saraksta ID -->
                                        <button type="submit" name="add_to_playlist" class="btn btn-success">Pievienot sarakstam</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                }
            } else {
                // Ziņojums, ja favorīti ir tukši
                echo '<p class="text-center">Nav pievienotu favorītu dziesmu.</p>';
            }
            ?>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
