    document.querySelector('button[type="submit"]').addEventListener('click', function(event) {
        event.preventDefault(); // Novērš noklusējuma formas iesniegšanu

        // Iegūst meklēšanas terminu
        var searchTerm = document.querySelector('input[type="search"]').value;

        // Pārbauda, vai ir ievadīts meklēšanas termins
        if (searchTerm.trim() !== '') {
            // Nosūta pieprasījumu uz serveri, lai iegūtu meklēšanas rezultātus
            fetch('meklet_dziesmas.php?search=' + encodeURIComponent(searchTerm))
                .then(response => response.json())
                .then(data => {
                    var searchResultsContainer = document.getElementById('searchResults');
                    searchResultsContainer.innerHTML = ''; // Notīra iepriekšējos rezultātus

                    // Pārbauda, vai ir atrasti rezultāti
                    if (data.length > 0) {
                        data.forEach(function(dziesma) {
                            var dziesmaHTML = `
                                <div class="card mb-3">
                                    <div class="card-body">
                                        <h5 class="card-title">${dziesma.nosaukums}</h5>
                                        <h6 class="card-subtitle mb-2 text-muted">${dziesma.autors}</h6>
                                        <audio controls>
                                            <source src="data:audio/mp3;base64,${dziesma.dziesma}" type="audio/mp3">
                                            Your browser does not support the audio element.
                                        </audio>
                                    </div>
                                </div>
                            `;
                            searchResultsContainer.innerHTML += dziesmaHTML;
                        });
                    } else {
                        searchResultsContainer.innerHTML = '<p>Nav atrasti rezultāti.</p>';
                    }

                    // Atver modālo logu
                    var myModal = new bootstrap.Modal(document.getElementById('searchModal'));
                    myModal.show();
                })
                .catch(error => console.error('Error:', error));
        }
    });
