let userLoggedIn = false;
let username = '';
const allowedSymbols = /^[a-zA-Z0-9@._-]+$/; // Allowed symbols for login

let incomes = [];
let expenses = [];
let budgets = [];

// Chart.js
let barChart = null;
let pieChart = null;

let message= null;
let modal= null;
let app= null;
showSection("register");

function logout() {
	modal=document.getElementById("Modal");
	modal.innerHTML="";
	document.getElementById("navigation").style.display="none";
	showSection("register");
}

function reg() {

}

function log_in() {
	const user = document.getElementById("username").value;
	const pass = document.getElementById("password").value;

	if (
		!allowedSymbols.test(user) || 
		!allowedSymbols.test(pass)
	) {
	    message.innerText = "Lūdzu, ievadiet derīgu lietotājvārdu un paroli.";
	    return;
	}

	userLoggedIn = true;
	username = user;
	document.getElementById("navigation").style.display="flex";
	showSection("income");
}

function showSection(sectionId) {
	fetch(`./${sectionId}.html`)
		.then(res=>res.text())
		.then(data=>{
			modal=document.getElementById("Modal");
			modal.innerHTML=data;
			setTimeout(this[sectionId],5);

		}
	);		
}

function bugets() {
    document.getElementById('btn').addEventListener("click", addBudget);
}

function reminders() {
    document.getElementById('reminderDate').valueAsDate = new Date();
    document.getElementById('btn').addEventListener("click",addReminder);
}

function expense() {
    document.getElementById('expenseDate').valueAsDate = new Date();
    document.getElementById('btn').addEventListener("click",addExpense);
}

function income(){
    document.getElementById('incomeDate').valueAsDate = new Date();
    document.getElementById('incomeAmount').value = 0;
    document.getElementById('btn').addEventListener("click",addIncome);
}

function login(){
    document.getElementById('btn_l').addEventListener("click",log_in);
    document.getElementById('btn_r').addEventListener("click",reg);
}

function register(){
    document.getElementById('btn_l').addEventListener("click",log_in);
    document.getElementById('btn_r').addEventListener("click",reg);
}

function toggleCustomCategory(type) {
	const categoryField = document.getElementById(`${type}Category`);
	const customCategoryField = document.getElementById(`custom${type.charAt(0).toUpperCase() + type.slice(1)}Category`);
	const customCategoryDisplay = document.getElementById(`custom${type.charAt(0).toUpperCase() + type.slice(1)}CategoryDisplay`);

	if (categoryField.value === 'cits') {
	    customCategoryField.classList.remove("hidden");
	} else {
	    customCategoryField.classList.add("hidden");
	    customCategoryDisplay.classList.add("hidden");
	}
}

function addIncome() {
	const amount = document.getElementById("incomeAmount");
	const date = document.getElementById("incomeDate");
	let check=0;
	
    if (parseFloat(amount.value)>0)
    { 
        amount.style.bordercolor="";
    }
    else
    {
        amount.style.bordercolor="red";
        check=1;
    }

    if (date.value!="")
    {
        date.style.bordercolor="";
    }
    else
    {
       date.style.bordercolor="red";
       check=1;
    }
    if (!check)
    {
        incomes.push(
            { 
                amount: parseFloat(amount.value),
                date:date.value 
                
            }
        );
        //updateCharts();
        const incomeList = document.getElementById("incomeList");
        const item = document.createElement("li");
        item.textContent = `${amount} EUR, ${date}`;
        incomeList.appendChild(item);
    }
    else
    {
        alert("Aizpildam VISUS laukus!")
    }
}

function addExpense() {
	const category = document.getElementById("expenseCategory").value 
	const customCategory = document.getElementById('customExpenseCategoryDisplay');
	const amount = document.getElementById("expenseAmount").value;
	const date = document.getElementById("expenseDate").value;

	if (category && amount && date) {
	    expenses.push({ category, amount: parseFloat(amount), date });
	   // updateCharts();
	    const expenseList = document.getElementById("expenseList");
	    const item = document.createElement("li");
	    if (category === "cits") {
		item.textContent = `${customCategory}: ${amount} EUR, ${date}`;
	    } else {
		item.textContent = `${category}: ${amount} EUR, ${date}`;
	    }
	    expenseList.appendChild(item);
	}
}

function addBudget() {
	const category = document.getElementById("budgetCategory").value;
	const customCategory = document.getElementById("customBudgetCategory").value;
	const amount = document.getElementById("budgetAmount").value;

	if (category && amount) {
	    budgets.push({ category, amount: parseFloat(amount) });
	    const budgetList = document.getElementById("budgetList");
	    const item = document.createElement("li");
	    if (category === "cits") {
			item.textContent = `${customCategory}: ${amount} EUR`;
		
	    } else {
			item.textContent = `${category}: ${amount} EUR`;
	    }
	    budgetList.appendChild(item);
	}
}

function updateCharts() {
	const selectedPeriods = Array.from(document.getElementById("periodFilter").selectedOptions).map(option => option.value);

	// Filter incomes and expenses based on selected periods
	const filteredIncomes = selectedPeriods.length === 0 || selectedPeriods.includes("all") ? incomes : incomes.filter(item => selectedPeriods.includes(item.date.slice(0, 7)));
	const filteredExpenses = selectedPeriods.length === 0 || selectedPeriods.includes("all") ? expenses : expenses.filter(item => selectedPeriods.includes(item.date.slice(0, 7)));

	const totalIncome = filteredIncomes.reduce((acc, income) => acc + income.amount, 0);
	const totalExpense = filteredExpenses.reduce((acc, expense) => acc + expense.amount, 0);

	// Update the period dropdown to only show months with data
	const periodSelect = document.getElementById("periodFilter");
	const monthsWithData = new Set([
	    ...filteredIncomes.map(income => income.date.slice(0, 7)),
	    ...filteredExpenses.map(expense => expense.date.slice(0, 7))
	]);
	periodSelect.innerHTML = '<option value="all">Visi periodi</option>';
	monthsWithData.forEach(month => {
	    const option = document.createElement("option");
	    option.value = month;
	    option.textContent = month;
	    periodSelect.appendChild(option);
	});

	// Bar chart update
	if (barChart) {
	    barChart.destroy();
	}

	const barCtx = document.getElementById("barChart").getContext("2d");
	barChart = new Chart(barCtx, {
	    type: "bar",
	    data: {
		labels: ["Ienākumi", "Izdevumi"],
		datasets: [{
		    label: "EUR",
		    data: [totalIncome, totalExpense],
		    backgroundColor: ["#00c8ff", "#ff4d4d"],
		    borderColor: ["#00b8e6", "#e60000"],
		    borderWidth: 1
		}]
	    },
	    options: {
		responsive: true,
		scales: {
		    y: {
			beginAtZero: true
		    }
		}
	    }
	});

	// Pie chart update
	if (pieChart) {
	    pieChart.destroy();
	}

	const pieCtx = document.getElementById("pieChart").getContext("2d");
	pieChart = new Chart(pieCtx, {
	    type: "pie",
	    data: {
		labels: ["Ienākumi", "Izdevumi"],
		datasets: [{
		    label: "EUR",
		    data: [totalIncome, totalExpense],
		    backgroundColor: ["#00c8ff", "#ff4d4d"]
		}]
	    }
	});
}

function addReminder() {
	const description = document.getElementById("reminderDescription").value;
	const date = document.getElementById("reminderDate").value;

	if (description && date) {
	    const reminderList = document.getElementById("reminderList");
	    const item = document.createElement("li");
	    item.textContent = `${description} - ${date}`;
	    reminderList.appendChild(item);
	}
}
