// Parāda/noslēpj logus
function openModal(id) {
    document.querySelectorAll('.modal').forEach(modal => modal.classList.remove('active'));
    document.getElementById(id).classList.add('active');
}

// Login funkcija ar simbolu validāciju
function login() {
    const username = document.getElementById("username").value;
    const password = document.getElementById("password").value;
    const allowedSymbols = /^[a-zA-Z0-9@.#?!]+$/;
    
    if (!allowedSymbols.test(username) || !allowedSymbols.test(password)) {
        document.getElementById("errorMessage").textContent = "Lūdzu, izmantojiet tikai atļautos simbolus!";
        return;
    }
    document.getElementById("loginModal").classList.remove("active");
    document.getElementById("navMenu").style.display = "flex";
}

// Budžeta pievienošana
function addBudget() {
    const category = document.getElementById("budgetCategory").value;
    const amount = document.getElementById("budgetAmount").value;
    const tbody = document.getElementById("budgetTable").querySelector("tbody");
    
    if (category && amount) {
        const row = document.createElement("tr");
        row.innerHTML = `<td>${category}</td><td>${amount} €</td>`;
        tbody.appendChild(row);
        document.getElementById("budgetCategory").value = '';
        document.getElementById("budgetAmount").value = '';
    }
}
