<?php
session_start();

// Pārbaudām, vai lietotājs ir pieslēdzies
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    $_SESSION['logged_in'] = false; // Ja lietotājs nav pieslēdzies, tad šī vērtība būs false
}

$errorMessage = '';

// Pārbaudes paroli un lietotājvārdu
function isValidUsername($username) {
    return preg_match("/^[a-zA-Z0-9@.]+$/", $username); // tikai burti un cipari
}

function isValidPassword($password) {
    // Piemēram, parolei var būt burti, cipari un speciālie simboli
    return preg_match("/^[a-zA-Z0-9@.]+$|^[^#$%^&*()_+={}\[\]:;\"\'<>,?\`~\\|-]*$/", $password);
}

// Ja pieslēgšanās forma tiek iesniegta
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['login'])) {
    $username = $_POST['username'];
    $password = $_POST['password'];

    // Pārbaudam vai lietotājvārds un parole ir derīgi
    echo "<pre>".isValidUsername($username)."-".isValidPassword($password)."</pre>";
    if (isValidUsername($username) && isValidPassword($password)) {
        // Piemērs - pārbauda, vai lietotājvārds un parole atbilst
       // if ($username === 'admin' && $password === '1234') {
            $_SESSION['logged_in'] = true;
            header('Location: ' . $_SERVER['PHP_SELF']); // Pārlādē lapu pēc veiksmīgas pieslēgšanās
            exit;
       // } else {
        //    $errorMessage = 'Nepareizs lietotājvārds vai parole!';
    }
    else {
        $errorMessage = 'Lietotājvārds vai parole satur neatļautus simbolus!';
    }
}

// Izlogoties
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit;
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Personīgā Finanšu Pārvaldība</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: Arial, sans-serif; background-color: #f9f9f9; color: #333; }
        .container { width: 100%; max-width: 400px; margin: 50px auto; background: #fff; border-radius: 8px; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1); padding: 20px; }
        h1 { font-size: 24px; text-align: center; margin-bottom: 20px; }
        .navigation { display: flex; justify-content: space-around; background: #00c8ff; padding: 10px 0; color: white; }
        .navigation button, .logout { background: transparent; border: none; color: white; font-size: 16px; cursor: pointer; }
        .section { padding: 20px; display: none; }
        .section.active { display: block; }
        .input-field { width: 100%; margin-bottom: 10px; padding: 10px; border: 1px solid #ddd; border-radius: 4px; font-size: 14px; }
        .btn { padding: 10px 20px; background-color: #4CAF50; color: white; border: none; border-radius: 4px; cursor: pointer; margin-top: 10px; font-size: 14px; }
        .hidden { display: none; }

        /* Sadaļas ir paslēptas, kamēr lietotājs nav pieslēdzies */
        .navigation, .section {
            display: none;
        }
        
        /* Ja lietotājs ir pieslēdzies, mēs parādām navigāciju un sadaļas */
        <?php if ($_SESSION['logged_in']): ?>
            .navigation, .section {
                display: block;
            }
        <?php endif; ?>
    </style>
</head>
<body>

    <?php if ($_SESSION['logged_in']): ?>
        <!-- Navigācija parādās tikai tad, kad lietotājs ir pieslēdzies -->
        <div class="navigation">
            <button onclick="showSection('income')">Ienākumi</button>
            <button onclick="showSection('expense')">Izdevumi</button>
            <button onclick="showSection('budget')">Budžets</button>
            <button onclick="showSection('reminders')">Atgādinājumi</button>
            <button onclick="showSection('charts')">Diagrammas</button>
            <a href="?logout=true" class="logout">Iziet</a>
        </div>

        <!-- Sadaļas tiek parādītas tikai pēc pieslēgšanās -->
        <div id="income" class="section active">
            <h2>Ienākumi</h2>
            <p>Šeit būs ienākumu pārvaldība.</p>
        </div>

        <div id="expense" class="section">
            <h2>Izdevumi</h2>
            <p>Šeit būs izdevumu pārvaldība.</p>
        </div>

        <div id="budget" class="section">
            <h2>Budžets</h2>
            <p>Šeit būs budžeta sadaļa.</p>
        </div>

        <div id="reminders" class="section">
            <h2>Atgādinājumi</h2>
            <p>Šeit būs atgādinājumi.</p>
        </div>

        <div id="charts" class="section">
            <h2>Diagrammas</h2>
            <p>Šeit būs diagrammas.</p>
        </div>

        <script>
            // Funkcija, lai parādītu izvēlēto sadaļu
            function showSection(sectionId) {
                // Slēpj visas sadaļas
                document.querySelectorAll('.section').forEach(section => {
                    section.classList.remove('active');
                });
                // Parāda izvēlēto sadaļu
                document.getElementById(sectionId).classList.add('active');
            }
        </script>

    <?php else: ?>
        <!-- Pieslēgšanās forma parādās tikai tad, kad lietotājs nav pieslēdzies -->
        <div class="container">
            <h1>Pieslēgties</h1>
            <form method="POST">
                <input type="text" name="username" class="input-field" placeholder="Lietotājvārds" required>
                <input type="password" name="password" class="input-field" placeholder="Parole" required>
                <button class="btn" type="submit" name="login">Pieslēgties</button>
            </form>
            <?php if ($errorMessage): ?>
                <p style="color: red; text-align: center;"><?php echo $errorMessage; ?></p>
            <?php endif; ?>
        </div>
    <?php endif; ?>

</body>
</html>
