<?php
session_start();

// Pārbauda, vai lietotājs ir pieslēdzies
if (!isset($_SESSION['user_email'])) {
    header("Location: log-in.php");
    exit;
}

// Savienojums ar datubāzi
include "database.php";

// Iegūst lietotāja datus no sesijas
$logged_in_user_email = $_SESSION['user_email'];
$sql = "SELECT * FROM rb_kvalif_signup_410 WHERE email = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $logged_in_user_email);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    die("Lietotājs nav atrasts datubāzē.");
}

$user = $result->fetch_assoc();
$stmt->close();

// Atjauno lietotāja datus, ja forma ir iesniegta
$success_message = '';
$error_message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $first_name = htmlspecialchars($_POST['first_name']);
    $last_name = htmlspecialchars($_POST['last_name']);
    $email = htmlspecialchars($_POST['email']);
    $phone = htmlspecialchars($_POST['phone']);
    $current_password = htmlspecialchars($_POST['current_password']);
    $new_password = htmlspecialchars($_POST['new_password']);

    // Pārbauda esošo paroli pirms jaunu datu saglabāšanas
    if (!empty($new_password)) {
        if (password_verify($current_password, $user['password'])) {
            $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);

            $update_sql = "UPDATE rb_kvalif_signup_410 SET first_name = ?, last_name = ?, email = ?, phone_number = ?, password = ? WHERE email = ?";
            $update_stmt = $conn->prepare($update_sql);
            $update_stmt->bind_param("ssssss", $first_name, $last_name, $email, $phone, $hashed_password, $logged_in_user_email);
        } else {
            $error_message = "Esošā parole ir nepareiza.";
        }
    } else {
        $update_sql = "UPDATE rb_kvalif_signup_410 SET first_name = ?, last_name = ?, email = ?, phone_number = ? WHERE email = ?";
        $update_stmt = $conn->prepare($update_sql);
        $update_stmt->bind_param("sssss", $first_name, $last_name, $email, $phone, $logged_in_user_email);
    }

    if ($update_stmt->execute()) {
        $success_message = "Profils veiksmīgi atjaunots!";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $logged_in_user_email);
        $stmt->execute();
        $result = $stmt->get_result();
        $user = $result->fetch_assoc();
        $stmt->close();
    } else {
        $error_message = "Neizdevās atjaunot profilu. Lūdzu, mēģiniet vēlreiz.";
    }
    $update_stmt->close();
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lietotāja profils</title>
    <link rel="stylesheet" href="../css/profile.css">
</head>
<body>
<header>
    <button onclick="window.location.href='../php/main.php'" class="home-btn">Uz sākumlapu</button>
</header>
<div class="profile-container">
    <div class="user-card">
        <img src="../icons/user.svg" alt="Lietotāja avatars" class="avatar">
        <h2><?php echo htmlspecialchars($user['first_name'] . ' ' . $user['last_name']); ?></h2>
        <p class="role"><?php echo htmlspecialchars($user['work_position']); ?></p>
        <p class="location"><?php echo htmlspecialchars($user['country'] . ', ' . $user['city']); ?></p>
    </div>
    <section class="profile-form">
        <h3>Rediģēt profilu</h3>
        <?php if ($success_message) { echo "<p class='success'>$success_message</p>"; } ?>
        <?php if ($error_message) { echo "<p class='error'>$error_message</p>"; } ?>
        <form method="POST" action="">
            <div class="form-group">
                <label for="first_name">Vārds</label>
                <input type="text" id="first_name" name="first_name" value="<?php echo htmlspecialchars($user['first_name']); ?>" required>
            </div>
            <div class="form-group">
                <label for="last_name">Uzvārds</label>
                <input type="text" id="last_name" name="last_name" value="<?php echo htmlspecialchars($user['last_name']); ?>" required>
            </div>
            <div class="form-group">
                <label for="email">E-pasts</label>
                <input type="email" id="email" name="email" value="<?php echo htmlspecialchars($user['email']); ?>" required>
            </div>
            <div class="form-group">
                <label for="phone">Telefona numurs</label>
                <input type="text" id="phone" name="phone" value="<?php echo htmlspecialchars($user['phone_number']); ?>">
            </div>
            <div class="form-group">
                <label for="current_password">Esošā parole</label>
                <input type="password" id="current_password" name="current_password">
            </div>
            <div class="form-group">
                <label for="new_password">Jaunā parole</label>
                <input type="password" id="new_password" name="new_password">
            </div>
            <div class="form-group read-only">
                <label>Amats</label>
                <input type="text" value="<?php echo htmlspecialchars($user['work_position']); ?>" readonly>
            </div>
            <div class="form-group read-only">
                <label>Līguma numurs</label>
                <input type="text" value="<?php echo htmlspecialchars($user['contract_number']); ?>" readonly>
            </div>
            <button type="submit" class="update-btn">Atjaunināt profilu</button>
        </form>
    </section>
</div>
</body>
</html>