<?php
include "database.php";

session_start();
header('Content-Type: application/json');

// Iegūst lietotāja ID un lomu no sesijas
$user_id = $_SESSION['user_id'] ?? null;
$role = $_SESSION['work_position'] ?? null;
$action = $_GET['action'] ?? $_POST['action'] ?? null;

// Pārbauda, vai lietotājs ir autorizēts
if (!$user_id || $role !== 'valdes_loceklis') {
    echo json_encode(["error" => "Piekļuve liegta."]);
    exit;
}

// Iegūst darbiniekus nolaižamajai izvēlnei
if ($action === "fetch-workers") {
    $sql = "SELECT id, first_name, last_name FROM rb_kvalif_signup_410 WHERE work_position = 'darbinieks'";
    $result = $conn->query($sql);
    if ($result) {
        echo json_encode(["data" => $result->fetch_all(MYSQLI_ASSOC)]);
    } else {
        echo json_encode(["error" => "Neizdevās iegūt darbiniekus: " . $conn->error]);
    }
    exit;
}

// Iegūst izvēlētā darbinieka darba stundas
elseif ($action === "fetch-work-hours") {
    $worker_id = $_GET['worker_id'] ?? null;
    if (!$worker_id) {
        echo json_encode(["error" => "Nepieciešams darbinieka ID."]);
        exit;
    }

    $sql = "SELECT date, clock_in_time, 
                   IF(clock_out_time IS NULL, 'Nav pieejams', clock_out_time) AS clock_out_time,
                   IF(clock_out_time IS NULL, 'Procesā', FORMAT(total_work_hours, 2)) AS total_work_hours
            FROM rb_kvalif_workhours_410 
            WHERE user_id = ? ORDER BY date DESC";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $worker_id);
    $stmt->execute();
    echo json_encode(["data" => $stmt->get_result()->fetch_all(MYSQLI_ASSOC)]);
    exit;
}

// Ja darbība nav norādīta vai ir nederīga
echo json_encode(["error" => "Nepareiza darbība."]);
$conn->close();
?>