<?php

include "database.php";

header('Content-Type: application/json');

// Materiāla pievienošanas loģika
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_GET['action']) && $_GET['action'] === 'add') {
    $data = json_decode(file_get_contents('php://input'), true);

    if (isset($data['sku_code'], $data['material_type'], $data['material_size'], $data['material_count'])) {
        $sku_code = $conn->real_escape_string($data['sku_code']);
        $material_type = $conn->real_escape_string($data['material_type']);
        $material_size = $conn->real_escape_string($data['material_size']);
        $material_count = intval($data['material_count']);

        // Pārbauda, vai materiāls ar to pašu SKU jau eksistē
        $check_sql = "SELECT material_count FROM rb_kvalif_materialcount_410 WHERE sku_code = '$sku_code'";
        $result = $conn->query($check_sql);

        if ($result && $result->num_rows > 0) {
            // Ja materiāls eksistē, atjaunina daudzumu
            $row = $result->fetch_assoc();
            $new_count = $row['material_count'] + $material_count;

            $status = "Pietiekami";
            if ($new_count == 0) {
                $status = "Beidzies";
            } elseif ($new_count < 10) {
                $status = "Mazāk par normu";
            }

            $update_sql = "UPDATE rb_kvalif_materialcount_410 
                           SET material_count = $new_count, status = '$status'
                           WHERE sku_code = '$sku_code'";
            if ($conn->query($update_sql) === TRUE) {
                echo json_encode(["success" => "Materiāla daudzums veiksmīgi atjaunināts."]);
            } else {
                echo json_encode(["error" => "Neizdevās atjaunināt materiālu: " . $conn->error]);
            }
        } else {
            // Ja materiāls neeksistē, pievieno jaunu ierakstu
            $status = "Pietiekami";
            if ($material_count == 0) {
                $status = "Beidzies";
            } elseif ($material_count < 10) {
                $status = "Mazāk par normu";
            }

            $insert_sql = "INSERT INTO rb_kvalif_materialcount_410 (sku_code, material_type, material_size, material_count, status)
                           VALUES ('$sku_code', '$material_type', '$material_size', $material_count, '$status')";
            if ($conn->query($insert_sql) === TRUE) {
                echo json_encode(["success" => "Materiāls veiksmīgi pievienots."]);
            } else {
                echo json_encode(["error" => "Neizdevās pievienot materiālu: " . $conn->error]);
            }
        }
    } else {
        echo json_encode(["error" => "Nepareizi dati."]);
    }
    exit;
}

// Materiāla noņemšanas loģika
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_GET['action']) && $_GET['action'] === 'remove') {
    $data = json_decode(file_get_contents('php://input'), true);

    if (isset($data['sku_code'], $data['remove_count'])) {
        $sku_code = $conn->real_escape_string($data['sku_code']);
        $remove_count = intval($data['remove_count']);

        $sql = "SELECT material_count FROM rb_kvalif_materialcount_410 WHERE sku_code = '$sku_code'";
        $result = $conn->query($sql);

        if ($result && $result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $new_count = $row['material_count'] - $remove_count;

            $status = "Pietiekami";
            if ($new_count <= 0) {
                $status = "Beidzies";
                $new_count = 0;
            } elseif ($new_count < 10) {
                $status = "Mazāk par normu";
            }

            $update_sql = "UPDATE rb_kvalif_materialcount_410 SET material_count = $new_count, status = '$status' WHERE sku_code = '$sku_code'";
            if ($conn->query($update_sql) === TRUE) {
                echo json_encode(["success" => "Materiāla daudzums veiksmīgi atjaunināts."]);
            } else {
                echo json_encode(["error" => "Neizdevās atjaunināt materiālu: " . $conn->error]);
            }
        } else {
            echo json_encode(["error" => "Materiāls netika atrasts."]);
        }
    } else {
        echo json_encode(["error" => "Nepareizi dati."]);
    }
    exit;
}

// Materiālu iegūšana
if ($_SERVER['REQUEST_METHOD'] === 'GET' && !isset($_GET['export'])) {
    $sql = "SELECT sku_code, material_type, material_size, material_count, status FROM rb_kvalif_materialcount_410";
    $result = $conn->query($sql);

    if ($result && $result->num_rows > 0) {
        $materials = [];
        while ($row = $result->fetch_assoc()) {
            $materials[] = $row;
        }
        echo json_encode($materials);
    } else {
        echo json_encode([]);
    }
    exit;
}

// Eksportēšana CSV formātā
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['export']) && $_GET['export'] === 'csv') {
    $sql = "SELECT * FROM rb_kvalif_materialcount_410";
    $result = $conn->query($sql);

    header('Content-Type: text/csv');
    header('Content-Disposition: attachment;filename=materials.csv');

    $output = fopen("php://output", "w");
    fputcsv($output, ['SKU kods', 'Materiāla tips', 'Materiāla izmērs', 'Materiāla skaits', 'Statuss']);

    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            fputcsv($output, $row);
        }
    }
    fclose($output);
    exit;
}

$conn->close();
?>