// Derīgo e-pasta domēnu saraksts validācijai
const validDomains = [
    "gmail.com",
    "yahoo.com",
    "hotmail.com",
    "outlook.com",
    "inbox.lv",
    "mail.lv"
];

const emailField = document.getElementById("email");
const emailError = document.getElementById("email-error");
const countryCodeField = document.getElementById("country-code");
const phoneNumberField = document.getElementById("phone-number");

// E-pasta validācija
emailField.addEventListener("blur", () => {
    const emailValue = emailField.value;
    const domain = emailValue.split("@")[1];

    if (domain && validDomains.includes(domain)) {
        emailError.textContent = "";
        emailField.style.borderColor = "#ddd";
    } else {
        emailError.textContent = "Lūdzu, ievadiet derīgu e-pasta adresi!";
        emailField.style.borderColor = "red";
    }
});

// Telefona numura atjaunināšana ar kodu zonu
countryCodeField.addEventListener("change", () => {
    phoneNumberField.value = countryCodeField.value + " ";
});